/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmc;

import com.sun.media.jmc.MediaCorruptedException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.ProtocolType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PeerManager;
import com.sun.media.jmcimpl.PlayerPeer;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Media {
    public static final double TIME_UNKNOWN = Double.NEGATIVE_INFINITY;
    URI uri;
    private MediaPeer peer;
    private ProtocolType protocolType;
    private VideoDataBuffer.Format[] formats;
    private static VideoDataBuffer.Format[] guessedPreferredFormats;

    public Media(URI uri) throws MediaUnavailableException, MediaUnsupportedException, MediaCorruptedException {
        this(uri, null);
    }

    public Media(URI uri, String[] formatsAsStrings) throws MediaUnavailableException, MediaUnsupportedException, MediaCorruptedException {
        this.uri = uri;
        this.protocolType = null;
        this.formats = Media.convertStringsToFormats(formatsAsStrings);
        if (this.getClass() == Media.class) {
            this.peer = PeerManager.getMediaPeer(uri, this.formats);
        }
    }

    private static VideoDataBuffer.Format[] convertStringsToFormats(String[] formatsAsStrings) {
        if (formatsAsStrings == null) {
            return Media.guessFormats();
        }
        ArrayList<VideoDataBuffer.Format> formats = new ArrayList<VideoDataBuffer.Format>(formatsAsStrings.length);
        for (int i = 0; i < formatsAsStrings.length; ++i) {
            try {
                formats.add(VideoDataBuffer.Format.valueOf(formatsAsStrings[i]));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return formats.toArray(new VideoDataBuffer.Format[0]);
    }

    private static synchronized VideoDataBuffer.Format[] guessFormats() {
        if (guessedPreferredFormats == null && (guessedPreferredFormats = AccessController.doPrivileged(new PrivilegedAction<VideoDataBuffer.Format[]>(){

            @Override
            public VideoDataBuffer.Format[] run() {
                try {
                    Class<?> pplClass = Class.forName("com.sun.javafx.sg.prism.PrismMediaFrameHandler");
                    Method getPrefFormatsM = pplClass.getMethod("getPreferredMediaFormats", new Class[0]);
                    return (VideoDataBuffer.Format[])getPrefFormatsM.invoke(pplClass, new Object[0]);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        })) == null) {
            guessedPreferredFormats = new VideoDataBuffer.Format[]{VideoDataBuffer.Format.XRGB};
        }
        return guessedPreferredFormats;
    }

    public VideoDataBuffer.Format[] getRequestedFormats() {
        return this.formats;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.peer != null ? this.peer.getMediaTracks() : null;
    }

    public double getDuration() {
        if (this.peer != null) {
            return this.peer.getDuration();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public ContainerType getContainerType() {
        if (this.peer != null) {
            return this.peer.getContainerType();
        }
        return null;
    }

    public ProtocolType getProtocolType() {
        if (this.protocolType == null && this.uri != null) {
            this.protocolType = ProtocolType.getTypeForScheme(this.uri.getScheme());
        }
        return this.protocolType;
    }

    public URI getURI() {
        return this.uri;
    }

    public <T> T getMetadata(String key, Class<T> clazz) {
        Object value;
        Map<String, Object> metadata = this.getMetadata();
        if (metadata != null && clazz.isInstance(value = metadata.get(key))) {
            return (T)value;
        }
        return null;
    }

    public Map<String, Object> getMetadata() {
        return this.peer != null ? this.peer.getMetadata() : null;
    }

    public int getFrameWidth() {
        return this.peer == null ? 0 : this.peer.getFrameWidth();
    }

    public int getFrameHeight() {
        return this.peer == null ? 0 : this.peer.getFrameHeight();
    }

    PlayerPeer getPlayerPeer() {
        PlayerPeer retval = null;
        if (this.peer != null) {
            retval = this.peer.getPlayerPeer();
        }
        return retval;
    }
}

