/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmc;

import com.sun.media.jmc.Media;
import com.sun.media.jmc.MediaCorruptedException;
import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.MediaView;
import com.sun.media.jmc.OperationUnsupportedException;
import com.sun.media.jmc.control.AudioControl;
import com.sun.media.jmc.control.MediaControl;
import com.sun.media.jmc.control.PlayControl;
import com.sun.media.jmc.control.SubtitleControl;
import com.sun.media.jmc.control.TrackControl;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.control.VideoRenderControl;
import com.sun.media.jmc.event.BufferDownloadListener;
import com.sun.media.jmc.event.BufferDownloadedProgressChangedEvent;
import com.sun.media.jmc.event.DurationChangedEvent;
import com.sun.media.jmc.event.MediaDurationListener;
import com.sun.media.jmc.event.MediaEvent;
import com.sun.media.jmc.event.MediaSizeListener;
import com.sun.media.jmc.event.MediaStateEvent;
import com.sun.media.jmc.event.MediaStateListener;
import com.sun.media.jmc.event.MediaTimeEvent;
import com.sun.media.jmc.event.MediaTimeListener;
import com.sun.media.jmc.event.SizeChangedEvent;
import com.sun.media.jmc.event.VideoRendererEvent;
import com.sun.media.jmc.event.VideoRendererListener;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmc.type.ProtocolType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PeerManager;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.Utils;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FilePermission;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaProvider
implements PlayControl {
    private State state = State.PAUSED;
    private State expectedState = null;
    private double rate = 1.0;
    private boolean autoRepeat = false;
    private int playCount = 1;
    private int currentCount = 0;
    private CounterReset resetCounter;
    private URI sourceUri = null;
    private VideoDataBuffer.Format[] formats;
    private List<MediaStateListener> mediaStateListeners = new ArrayList<MediaStateListener>();
    private List<VideoRendererListener> videoUpdateListeners = new ArrayList<VideoRendererListener>();
    private List<BufferDownloadListener> bufferDownloadListeners = new ArrayList<BufferDownloadListener>();
    private List<MediaDurationListener> mediaDurationListeners = new ArrayList<MediaDurationListener>();
    private List<MediaSizeListener> mediaSizeListeners = new ArrayList<MediaSizeListener>();
    private List<Double> notificationTimes = new ArrayList<Double>();
    private HashMap<Double, List<MediaTimeListener>> notificationTimesMap = new HashMap();
    private PlayerPeer player = null;
    private MediaPeer mediaInfo = null;
    private EventQueueThread eventQueueThread = null;
    private AudioControl audioControl = null;
    private VideoControl videoControl = null;
    private SubtitleControl subtitleControl = null;
    private VideoRenderControl videoRenderControl = null;
    private TrackControl trackControl = null;
    private List<MediaControl> controls = new ArrayList<MediaControl>();
    private PropertyChangeSupport propertyChangeSupport;
    private static RuntimePermission mediaAccessPermssion = new RuntimePermission("com.sun.media.jmc.accessMedia");
    private Map<CapabilityKey, Object> capabilities = new HashMap<CapabilityKey, Object>();
    private static final FilePermission readMediaFilePermission = new FilePermission("<<ALL FILES>>", "read");
    double mediaTime = 0.0;
    private Timer mediaTimer = null;
    private MediaTimerTaskCallback mediaTimerTaskCallback = null;
    private boolean mediaTimerTaskPaused = true;
    List views = new LinkedList();

    public MediaProvider() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateCapabilities();
    }

    public MediaProvider(URI uri) throws MediaUnavailableException, MediaUnsupportedException, MediaCorruptedException {
        this();
        this.setSource(uri);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static List<ContainerType> getSupportedContainerTypes() {
        return PeerManager.getSupportedContainerTypes();
    }

    public static boolean renderingControlSupported(URI uri) {
        String uriStr = uri.toASCIIString();
        return uriStr.toLowerCase().endsWith(".ogg");
    }

    public static List<ProtocolType> getSupportedProtocols(EncodingType encoding) {
        return null;
    }

    public static List<EncodingType> getSupportedEncodings(ContainerType container) {
        return null;
    }

    public <T extends MediaControl> T getControl(Class<T> controlClass) {
        MediaControl control = null;
        if (controlClass == AudioControl.class) {
            control = (MediaControl)controlClass.cast(this.audioControl);
        } else if (controlClass == VideoControl.class) {
            control = (MediaControl)controlClass.cast(this.videoControl);
        } else if (controlClass == VideoRenderControl.class) {
            this.checkRenderAccess();
            control = (MediaControl)controlClass.cast(this.videoRenderControl);
        } else if (controlClass == TrackControl.class) {
            control = (MediaControl)controlClass.cast(this.trackControl);
        } else if (controlClass == PlayControl.class) {
            control = (MediaControl)controlClass.cast(this);
        }
        return (T)(this.controls.contains(control) ? control : null);
    }

    private final void checkRenderAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(mediaAccessPermssion);
        }
    }

    public List<MediaControl> getControls() {
        boolean hasRenderAccess;
        try {
            this.checkRenderAccess();
            hasRenderAccess = true;
        }
        catch (SecurityException e) {
            hasRenderAccess = false;
        }
        if (hasRenderAccess) {
            return Collections.unmodifiableList(this.controls);
        }
        ArrayList<MediaControl> controlList = new ArrayList<MediaControl>();
        for (MediaControl control : this.controls) {
            if (control instanceof VideoRenderControl) continue;
            controlList.add(control);
        }
        return Collections.unmodifiableList(controlList);
    }

    private void updateCapabilities() {
        if (this.player == null) {
            this.capabilities.put(CapabilityKey.SUPPORTS_SEEKING, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_RATE, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_NOTIFICATION_TIMES, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_VOLUME, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_BALANCE, Boolean.FALSE);
            this.capabilities.put(CapabilityKey.SUPPORTS_FADER, Boolean.FALSE);
        } else {
            this.capabilities.put(CapabilityKey.SUPPORTS_SEEKING, this.isSupported(PlayerPeer.Capabilities.supportsSeeking));
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_RATE, this.isSupported(PlayerPeer.Capabilities.supportsRate));
            this.capabilities.put(CapabilityKey.SUPPORTS_NOTIFICATION_TIMES, this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes));
            this.capabilities.put(CapabilityKey.SUPPORTS_SET_VOLUME, this.isSupported(PlayerPeer.Capabilities.supportsVolume));
            this.capabilities.put(CapabilityKey.SUPPORTS_BALANCE, this.isSupported(PlayerPeer.Capabilities.supportsBalance));
            this.capabilities.put(CapabilityKey.SUPPORTS_FADER, this.isSupported(PlayerPeer.Capabilities.supportsFader));
        }
    }

    public Map<CapabilityKey, Object> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public <T> T getCapability(CapabilityKey key, Class<T> capClass) {
        return capClass.cast(this.capabilities.get((Object)key));
    }

    public <MC extends MediaControl> List<MC> getControls(Class<MC> controlClass) {
        if (controlClass == VideoRenderControl.class) {
            this.checkRenderAccess();
        }
        LinkedList<MC> retList = new LinkedList<MC>();
        for (MediaControl mc : this.controls) {
            if (!controlClass.isInstance(mc)) continue;
            try {
                retList.add(controlClass.cast(mc));
            }
            catch (ClassCastException cce) {}
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(URI uri) throws MediaUnsupportedException, MediaUnavailableException, MediaCorruptedException {
        SecurityManager sm;
        if (uri == null) {
            this.close();
            return;
        }
        uri.normalize();
        if (this.sourceUri == uri) {
            return;
        }
        if (uri.getScheme().equalsIgnoreCase("file") && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(readMediaFilePermission);
        }
        this.sourceUri = uri;
        try {
            if (this.player != null) {
                boolean needNewPeer = true;
                if (PeerManager.isPeerClassForURI(uri, this.player.getClass(), this.formats)) {
                    try {
                        this.player.setSource(uri);
                        needNewPeer = false;
                    }
                    catch (MediaException mediaException) {
                        // empty catch block
                    }
                }
                if (needNewPeer) {
                    this.freePeer();
                }
            }
            if (this.player == null) {
                this.player = PeerManager.getPlayerPeer(uri, false, this.formats);
            }
            this.setPeer(this.player);
        }
        finally {
            if (this.player == null) {
                this.sourceUri = null;
                this.destroyMediaTimer();
                this.destroyEventQueue();
            }
            this.updateCapabilities();
        }
    }

    public void setPlayerPeerFromMedia(Media theMedia) throws MediaUnsupportedException, MediaUnavailableException, MediaCorruptedException {
        if (theMedia == null) {
            this.close();
            return;
        }
        if (this.player != null) {
            this.player.setSource(null);
        }
        this.formats = theMedia.getRequestedFormats();
        this.player = theMedia.getPlayerPeer();
        if (this.player == null) {
            this.setSource(theMedia.uri);
        } else {
            this.sourceUri = theMedia.uri;
            this.setPeer(this.player);
            this.updateCapabilities();
        }
    }

    public URI getSource() {
        return this.sourceUri;
    }

    @Override
    public void play() {
        this.pauseMediaTimerTaskCallback(false);
        this.expectedState = State.STARTED;
        if (this.player != null) {
            if (this.resetCounter == CounterReset.RESET_ON_PLAY) {
                this.resetCounter = CounterReset.RESET_ON_PLAY;
                this.currentCount = 0;
            }
            if (this.currentCount + 1 < this.playCount) {
                this.player.setAutoRepeat(true);
            } else {
                this.player.setAutoRepeat(false);
            }
            this.player.start();
        }
    }

    @Override
    public void pause() {
        if (this.player != null) {
            this.expectedState = State.PAUSED;
            this.player.pause();
        } else {
            this.state = State.PAUSED;
        }
        this.pauseMediaTimerTaskCallback(true);
    }

    @Override
    public double setMediaTime(double time) throws OperationUnsupportedException {
        if (time < 0.0) {
            time = 0.0;
        }
        if (this.player != null) {
            this.player.setMediaTime(time);
        }
        return this.mediaTime;
    }

    @Override
    public double getMediaTime() {
        double time = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            time = this.player.getMediaTime();
        }
        return time;
    }

    @Override
    public double setStartTime(double time) throws OperationUnsupportedException {
        if (time < 0.0) {
            time = 0.0;
        }
        if (this.player != null) {
            this.player.setStartTime(time);
        }
        return time;
    }

    @Override
    public double getStartTime() {
        double time = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            time = this.player.getStartTime();
        }
        return time;
    }

    @Override
    public double setStopTime(double time) throws OperationUnsupportedException {
        if (this.player != null) {
            this.player.setStopTime(time);
        }
        return time;
    }

    @Override
    public double getStopTime() {
        double time = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            time = this.player.getStopTime();
        }
        return time;
    }

    @Override
    public double getDuration() {
        double time = Double.NEGATIVE_INFINITY;
        if (this.player != null) {
            time = this.player.getDuration();
        }
        return time;
    }

    @Override
    public double setRate(double newRate) {
        double previousRate = this.rate;
        this.rate = newRate;
        if (this.player != null) {
            this.player.setRate(newRate);
            this.propertyChangeSupport.firePropertyChange("RATE_CHANGED", previousRate, this.rate);
        }
        return this.rate;
    }

    @Override
    public double getRate() {
        if (this.player != null) {
            this.rate = this.player.getRate();
        }
        return this.rate;
    }

    @Override
    public boolean isPlaying() {
        return this.expectedState == null ? this.state == State.STARTED : this.expectedState == State.STARTED;
    }

    @Override
    public void addNotificationTime(double time, MediaTimeListener listener, boolean isRepeating) throws OperationUnsupportedException {
        if (!isRepeating) {
            this.addNotificationTime(time, listener);
        }
    }

    @Override
    public void addNotificationTime(double time, MediaTimeListener listener) throws OperationUnsupportedException {
        List<MediaTimeListener> mtl;
        if (!this.notificationTimes.contains(time)) {
            this.notificationTimes.add(new Double(time));
        }
        if ((mtl = this.notificationTimesMap.get(time)) == null) {
            mtl = new ArrayList<MediaTimeListener>();
            mtl.add(listener);
            this.notificationTimesMap.put(time, mtl);
        } else {
            mtl.add(listener);
        }
        if (this.player != null) {
            if (this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes)) {
                try {
                    this.player.setNotificationTimes(this.notificationTimes);
                }
                catch (Exception e) {
                    System.err.println("Unexpected exception setting notification time");
                    throw new OperationUnsupportedException();
                }
            } else {
                throw new OperationUnsupportedException();
            }
        }
    }

    @Override
    public void removeNotificationTime(double time, MediaTimeListener listener) {
        List<MediaTimeListener> mtl = this.notificationTimesMap.get(time);
        if (mtl == null) {
            System.err.println("no timer for time: " + time);
        } else {
            int index = mtl.indexOf(listener);
            if (index == -1) {
                System.err.println("No Listener for timer:" + listener + " at " + time);
            } else {
                mtl.remove(index);
                if (mtl.isEmpty()) {
                    this.notificationTimesMap.remove(mtl);
                    this.notificationTimes.remove(time);
                }
            }
        }
        if (this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes)) {
            try {
                this.player.setNotificationTimes(this.notificationTimes);
            }
            catch (Exception e) {
                System.err.println("unexpected exception removing NotificationTime" + e);
            }
        }
    }

    public boolean isNotificationTimeSupported() {
        return this.isSupported(PlayerPeer.Capabilities.supportsNotificationTimes);
    }

    @Override
    public void setRepeating(boolean autoRepeat) {
        boolean prev = this.autoRepeat;
        this.autoRepeat = autoRepeat;
        if (this.player != null) {
            this.player.setAutoRepeat(autoRepeat);
        }
        this.propertyChangeSupport.firePropertyChange("REPEATING_CHANGED", prev, autoRepeat);
        if (autoRepeat) {
            this.setPlayCount(Integer.MAX_VALUE);
        } else {
            this.setPlayCount(1);
        }
    }

    @Override
    public boolean isRepeating() {
        return this.autoRepeat;
    }

    @Override
    public void setPlayCount(int newPlayCount) {
        int prevPlayCount = this.playCount;
        this.playCount = newPlayCount;
        if (this.player != null) {
            this.player.setAutoRepeat(this.playCount > 1);
            this.autoRepeat = this.playCount > 1;
        }
        this.propertyChangeSupport.firePropertyChange("PLAY_COUNT_CHANGED", prevPlayCount, newPlayCount);
    }

    @Override
    public int getPlayCount() {
        return this.playCount;
    }

    @Override
    public void setCurrentPlayCount(int setCount) {
        if (setCount >= 0 && setCount < this.playCount) {
            this.currentCount = setCount;
        }
    }

    @Override
    public int getCurrentPlayCount() {
        return this.currentCount;
    }

    @Override
    public String getName() {
        return "MediaProvider PlayControl";
    }

    public void addMediaDurationListener(MediaDurationListener listener) {
        this.mediaDurationListeners.add(listener);
    }

    public void removeMediaDurationListener(MediaDurationListener listener) {
        this.mediaDurationListeners.remove(listener);
    }

    public void addBufferDownloadListener(BufferDownloadListener listener) {
        this.bufferDownloadListeners.add(listener);
    }

    public void removeBufferDownloadListener(BufferDownloadListener listener) {
        this.bufferDownloadListeners.remove(listener);
    }

    public void addMediaStateListener(MediaStateListener listener) {
        this.mediaStateListeners.add(listener);
    }

    public void removeMediaStateListener(MediaStateListener listener) {
        this.mediaStateListeners.remove(listener);
    }

    public void addMediaSizeListener(MediaSizeListener listener) {
        this.mediaSizeListeners.add(listener);
    }

    public void removeMediaSizeListener(MediaSizeListener listener) {
        this.mediaSizeListeners.remove(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addMediaTimerTaskCallback(MediaTimerTaskCallback inMediaTimerTaskCallback) {
        if (this.mediaTimerTaskCallback == null) {
            this.mediaTimerTaskCallback = inMediaTimerTaskCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaTimerTaskCallback() {
        if (this.mediaTimerTaskCallback != null) {
            MediaTimerTaskCallback mediaTimerTaskCallback = this.mediaTimerTaskCallback;
            synchronized (mediaTimerTaskCallback) {
                this.mediaTimerTaskCallback = null;
            }
        }
    }

    public void pauseMediaTimerTaskCallback(boolean pause) {
        this.mediaTimerTaskPaused = pause;
    }

    private void createMediaTimer() {
        if (this.mediaTimer == null) {
            this.mediaTimer = new Timer();
            this.mediaTimer.scheduleAtFixedRate((TimerTask)new MediaTimerTask(), 0L, 100L);
        }
    }

    private void destroyMediaTimer() {
        if (this.mediaTimer != null) {
            this.mediaTimer.cancel();
            this.mediaTimer = null;
        }
    }

    private void createEventQueue() {
        if (this.eventQueueThread == null) {
            this.eventQueueThread = new EventQueueThread();
            this.eventQueueThread.start();
        }
    }

    private void destroyEventQueue() {
        if (this.eventQueueThread != null) {
            this.eventQueueThread.terminateLoop();
            this.eventQueueThread = null;
        }
    }

    private void postEvent(MediaEvent event) {
        if (this.eventQueueThread != null) {
            this.eventQueueThread.postEvent(event);
        }
    }

    private void setPeer(PlayerPeer peer) {
        this.player = peer;
        this.createEventQueue();
        this.createMediaTimer();
        this.controls.add(this);
        if (this.audioControl == null) {
            this.audioControl = new AudioCtrl();
        }
        this.controls.add(this.audioControl);
        if (this.videoControl == null) {
            this.videoControl = new VideoCtrl();
        }
        this.controls.add(this.videoControl);
        if (this.subtitleControl == null) {
            this.subtitleControl = new SubtitleCtrl();
        }
        this.controls.add(this.subtitleControl);
        if (this.videoRenderControl == null) {
            this.videoRenderControl = new VideoRenderCtrl();
        }
        this.controls.add(this.videoRenderControl);
        if (this.trackControl == null) {
            this.trackControl = new TrackCtrl();
        }
        this.controls.add(this.trackControl);
        this.player.setEventQueue(this.eventQueueThread.getEventQuery());
        this.player.setNotificationTimes(this.notificationTimes);
        this.player.setAutoRepeat(this.autoRepeat);
        for (MediaControl control : this.controls) {
            if (!(control instanceof PersistControl)) continue;
            PersistControl pctrl = (PersistControl)((Object)control);
            pctrl.restoreProperties();
        }
    }

    private void freePeer() {
        if (this.player != null) {
            this.player.setEventQueue(null);
            this.player.dispose();
            this.player = null;
            this.mediaInfo = null;
        }
        this.controls.clear();
    }

    private boolean isSupported(PlayerPeer.Capabilities cap) {
        if (this.player != null) {
            return this.player.getCapabilities().contains((Object)cap);
        }
        return false;
    }

    private void close() {
        this.pause();
        this.freePeer();
        this.sourceUri = null;
        this.destroyMediaTimer();
        this.destroyEventQueue();
        this.updateCapabilities();
    }

    private void dispose() {
        this.close();
        if (this.mediaStateListeners != null) {
            this.mediaStateListeners.clear();
        }
        if (this.videoUpdateListeners != null) {
            this.videoUpdateListeners.clear();
        }
    }

    void addView(MediaView view) {
        if (this.views.contains(view)) {
            System.err.println("Already have view?");
            return;
        }
        this.views.add(view);
        if (view instanceof VideoRendererListener) {
            this.videoRenderControl.addVideoRendererListener((VideoRendererListener)((Object)view));
        } else {
            System.err.println("View does not support RendererListener");
        }
    }

    void removeView(MediaView view) {
        if (this.views.contains(view)) {
            if (view instanceof VideoRendererListener) {
                this.videoRenderControl.removeVideoRendererListener((VideoRendererListener)((Object)view));
            }
        } else {
            System.err.println("removeView: no such view");
            return;
        }
        this.views.remove(view);
    }

    private class AudioCtrl
    implements AudioControl,
    PersistControl {
        float volume = 1.0f;
        boolean isMuted = false;
        float balance = 0.0f;
        float fader = 0.0f;
        Locale language = null;

        public float setVolume(float newValue) {
            float prevValue = this.volume;
            this.volume = Utils.reduceValue(newValue, 0.0f, 1.0f);
            if (!this.isMuted && MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                MediaProvider.this.player.setVolume(this.volume);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("VOLUME_CHANGED", Float.valueOf(prevValue), Float.valueOf(this.volume));
            return this.volume;
        }

        public float getVolume() {
            if (!this.isMuted && MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                this.volume = MediaProvider.this.player.getVolume();
            }
            return this.volume;
        }

        public void setMute(boolean newValue) {
            boolean prevValue = this.isMuted;
            this.isMuted = newValue;
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                if (this.isMuted) {
                    MediaProvider.this.player.setVolume(0.0f);
                } else {
                    MediaProvider.this.player.setVolume(this.volume);
                }
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("MUTE_CHANGED", prevValue, this.isMuted);
        }

        public boolean isMuted() {
            return this.isMuted;
        }

        public float setBalance(float newValue) {
            float prevValue = this.balance;
            this.balance = Utils.reduceValue(newValue, -1.0f, 1.0f);
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsBalance)) {
                MediaProvider.this.player.setBalance(this.balance);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("BALANCE_CHANGED", Float.valueOf(prevValue), Float.valueOf(this.balance));
            return this.balance;
        }

        public float getBalance() {
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsBalance)) {
                this.balance = MediaProvider.this.player.getBalance();
            }
            return this.balance;
        }

        public float setFader(float newValue) {
            float prevValue = this.fader;
            this.fader = Utils.reduceValue(newValue, -1.0f, 1.0f);
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsFader)) {
                MediaProvider.this.player.setFader(this.fader);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("FADER_CHANGED", Float.valueOf(prevValue), Float.valueOf(this.fader));
            return this.fader;
        }

        public float getFader() {
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsFader)) {
                this.fader = MediaProvider.this.player.getFader();
            }
            return this.fader;
        }

        public void setAudioLanguage(Locale language) throws OperationUnsupportedException {
            this.language = language;
        }

        public String getName() {
            return "MediaProvider AudioControl";
        }

        public void restoreProperties() {
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsVolume)) {
                if (this.isMuted) {
                    MediaProvider.this.player.setVolume(0.0f);
                } else {
                    MediaProvider.this.player.setVolume(this.volume);
                }
            }
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsBalance)) {
                MediaProvider.this.player.setBalance(this.balance);
            }
            if (MediaProvider.this.isSupported(PlayerPeer.Capabilities.supportsFader)) {
                MediaProvider.this.player.setFader(this.fader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CapabilityKey {
        SUPPORTS_SEEKING,
        SUPPORTS_SET_RATE,
        SUPPORTS_NOTIFICATION_TIMES,
        SUPPORTS_SET_VOLUME,
        SUPPORTS_BALANCE,
        SUPPORTS_FADER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CounterReset {
        RESET_NONE,
        RESET_AT_EOM,
        RESET_ON_PLAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventQueueThread
    extends Thread {
        private BlockingQueue<MediaEvent> eventQueue = new LinkedBlockingQueue<MediaEvent>();
        volatile boolean stopped = false;

        EventQueueThread() {
            this.setName("JMC MediaProvider EventQueueThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block8: while (!this.stopped) {
                try {
                    MediaEvent event;
                    MediaEvent evt = this.eventQueue.take();
                    if (this.stopped) continue;
                    if (evt instanceof MediaStateEvent) {
                        event = (MediaStateEvent)evt;
                        MediaStateEvent.MediaState mediaState = ((MediaStateEvent)event).getMediaState();
                        switch (mediaState) {
                            case END_OF_MEDIA: {
                                if (!MediaProvider.this.autoRepeat) {
                                    MediaProvider.this.pause();
                                }
                                if (MediaProvider.this.resetCounter == CounterReset.RESET_AT_EOM) {
                                    MediaProvider.this.resetCounter = CounterReset.RESET_ON_PLAY;
                                }
                                for (MediaStateListener l : MediaProvider.this.mediaStateListeners) {
                                    l.endOfMediaReached((MediaStateEvent)event);
                                }
                                continue block8;
                            }
                            case STARTED: {
                                if (MediaProvider.this.expectedState == State.STARTED) {
                                    MediaProvider.this.expectedState = null;
                                }
                                if (MediaProvider.this.state == State.STARTED) break;
                                MediaProvider.this.state = State.STARTED;
                                for (MediaStateListener l : MediaProvider.this.mediaStateListeners) {
                                    l.playerStarted((MediaStateEvent)event);
                                }
                                MediaProvider.this.propertyChangeSupport.firePropertyChange("PAUSED_CHANGED", true, false);
                                break;
                            }
                            case STOPPED: {
                                if (MediaProvider.this.expectedState == State.PAUSED) {
                                    MediaProvider.this.expectedState = null;
                                }
                                if (MediaProvider.this.state == State.PAUSED) break;
                                MediaProvider.this.state = State.PAUSED;
                                for (MediaStateListener l : MediaProvider.this.mediaStateListeners) {
                                    l.playerStopped((MediaStateEvent)event);
                                }
                                MediaProvider.this.propertyChangeSupport.firePropertyChange("PAUSED_CHANGED", false, true);
                                break;
                            }
                            case REPEAT: {
                                MediaProvider.this.currentCount++;
                                if (MediaProvider.this.playCount != Integer.MAX_VALUE && MediaProvider.this.currentCount + 1 >= MediaProvider.this.playCount) {
                                    MediaProvider.this.player.setAutoRepeat(false);
                                    MediaProvider.this.resetCounter = CounterReset.RESET_AT_EOM;
                                }
                                if (MediaProvider.this.state != State.STARTED) {
                                    // empty if block
                                }
                                for (MediaStateListener l : MediaProvider.this.mediaStateListeners) {
                                    l.playerRepeated((MediaStateEvent)event);
                                }
                                break;
                            }
                        }
                        continue;
                    }
                    if (evt instanceof VideoRendererEvent) {
                        event = (VideoRendererEvent)evt;
                        for (VideoRendererListener l : MediaProvider.this.videoUpdateListeners) {
                            l.videoFrameUpdated((VideoRendererEvent)event);
                        }
                        continue;
                    }
                    if (evt instanceof MediaTimeEvent) {
                        event = (MediaTimeEvent)evt;
                        Double key = new Double(((MediaTimeEvent)event).getNotificationTime());
                        List listeners = (List)MediaProvider.this.notificationTimesMap.get(key);
                        if (listeners == null) continue;
                        for (MediaTimeListener l : listeners) {
                            l.notificationTimeReached((MediaTimeEvent)event);
                        }
                        continue;
                    }
                    if (evt instanceof BufferDownloadedProgressChangedEvent) {
                        for (EventListener l : MediaProvider.this.bufferDownloadListeners) {
                            l.mediaDownloadProgressChanged((BufferDownloadedProgressChangedEvent)evt);
                        }
                        continue;
                    }
                    if (evt instanceof DurationChangedEvent) {
                        for (EventListener l : MediaProvider.this.mediaDurationListeners) {
                            l.mediaDurationChanged((DurationChangedEvent)evt);
                        }
                        continue;
                    }
                    if (!(evt instanceof SizeChangedEvent)) continue;
                    for (EventListener l : MediaProvider.this.mediaSizeListeners) {
                        l.mediaSizeChanged((SizeChangedEvent)evt);
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        public BlockingQueue<MediaEvent> getEventQuery() {
            return this.eventQueue;
        }

        public void postEvent(MediaEvent event) {
            if (this.eventQueue != null) {
                this.eventQueue.offer(event);
            }
        }

        public void terminateLoop() {
            this.stopped = true;
            this.eventQueue.offer(new MediaEvent(0.0, "dummy event", this));
        }
    }

    private class MediaTimerTask
    extends TimerTask {
        private MediaTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (MediaProvider.this.mediaTimerTaskCallback != null && !MediaProvider.this.mediaTimerTaskPaused) {
                MediaTimerTaskCallback mediaTimerTaskCallback = MediaProvider.this.mediaTimerTaskCallback;
                synchronized (mediaTimerTaskCallback) {
                    MediaProvider.this.mediaTimerTaskCallback.invoke();
                }
            }
        }
    }

    public static interface MediaTimerTaskCallback {
        public void invoke();
    }

    private static interface PersistControl {
        public void restoreProperties();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STARTED,
        PAUSED;

    }

    private class SubtitleCtrl
    implements SubtitleControl,
    PersistControl {
        public boolean containsSubtitles() {
            return false;
        }

        public boolean displaySubtitles(boolean display) {
            return false;
        }

        public void setSubtitleLanguage(Locale language) throws OperationUnsupportedException {
        }

        public String getName() {
            return "MediaProvider SubtitleControl";
        }

        public void restoreProperties() {
            if (MediaProvider.this.player != null) {
                // empty if block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TrackCtrl
    implements TrackControl {
        @Override
        public List<MediaTrack> getMediaTracks() {
            return null;
        }

        @Override
        public void enableTrack(MediaTrack track) {
        }

        @Override
        public void disableTrack(MediaTrack track) {
        }

        @Override
        public boolean isEnabled(MediaTrack track) {
            return true;
        }

        @Override
        public String getName() {
            return "MediaProvider TrackControl";
        }
    }

    private class VideoCtrl
    implements VideoControl,
    PersistControl {
        VideoControl.ResizeBehavior resizeBehavior = VideoControl.ResizeBehavior.Preserve;

        public int getFrameWidth() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameWidth();
            }
            return 0;
        }

        public int getFrameHeight() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameHeight();
            }
            return 0;
        }

        public void setResizeBehavior(VideoControl.ResizeBehavior behavior) {
            VideoControl.ResizeBehavior previousBehavior = this.resizeBehavior;
            this.resizeBehavior = behavior;
            if (MediaProvider.this.player != null) {
                MediaProvider.this.player.setResizeBehavior(behavior);
            }
            MediaProvider.this.propertyChangeSupport.firePropertyChange("RESIZE_BEHAVIOR_CHANGED", (Object)previousBehavior, (Object)behavior);
        }

        public void setSourceRegion(Rectangle rect) {
        }

        public void setFullScreen(boolean mode) throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Fullscreen mode not supported.");
        }

        public String getName() {
            return "MediaProvider VideoControl";
        }

        public void restoreProperties() {
            if (MediaProvider.this.player != null) {
                MediaProvider.this.player.setResizeBehavior(this.resizeBehavior);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VideoRenderCtrl
    implements VideoRenderControl {
        @Override
        public boolean isRenderable() {
            return false;
        }

        @Override
        public void setDefaultRendering(boolean renderToDefault) {
        }

        @Override
        public boolean getDefaultRendering() {
            return true;
        }

        @Override
        public void addVideoRendererListener(VideoRendererListener listener) {
            MediaProvider.this.videoUpdateListeners.add(listener);
        }

        @Override
        public void removeVideoRendererListener(VideoRendererListener listener) {
            MediaProvider.this.videoUpdateListeners.remove(listener);
        }

        @Override
        public void getData(VideoDataBuffer data) {
            MediaProvider.this.player.getFrameData(data);
        }

        @Override
        public void releaseData(VideoDataBuffer data) {
            MediaProvider.this.player.releaseFrameData(data);
        }

        @Override
        public List<VideoDataBuffer.Format> getFormats() {
            return null;
        }

        @Override
        public int getFrameWidth() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameWidth();
            }
            return 0;
        }

        @Override
        public int getFrameHeight() {
            if (MediaProvider.this.player != null) {
                return MediaProvider.this.player.getFrameHeight();
            }
            return 0;
        }

        @Override
        public String getName() {
            return "MediaProvider VideoRenderControl";
        }
    }
}

