/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.JMFPlayerPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.spi.DefaultPlayerPeerProvider;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMFPlayerProvider
extends DefaultPlayerPeerProvider {
    private static final boolean trace = false;
    static ContainerType[] myContainerTypes = new ContainerType[0];
    static boolean initialized = false;

    public JMFPlayerProvider() {
        super(myContainerTypes, PlayerPeerProvider.PlaybackMode.Unknown);
    }

    private synchronized boolean init() {
        if (!initialized) {
            try {
                Class.forName("javax.media.Manager");
                initialized = true;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return initialized;
    }

    @Override
    public PlayerPeerProvider.PlaybackMode canPlay(URI uri, VideoDataBuffer.Format[] formats) {
        if (!this.init()) {
            return PlayerPeerProvider.PlaybackMode.None;
        }
        return super.canPlay(uri, formats);
    }

    @Override
    public PlayerPeer createPlayerPeer(URI uri, VideoDataBuffer.Format[] formats) throws MediaException {
        try {
            return new JMFPlayerPeer(uri);
        }
        catch (Exception e) {
            throw new MediaException("Cannot create JMF player for: " + uri, e);
        }
    }

    @Override
    public Class<? extends PlayerPeer> getPlayerPeerClass() {
        return null;
    }
}

