/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.type.EncodingType;
import java.util.Locale;

class DShowEncodings {
    DShowEncodings() {
    }

    private static ACMEnc getWaveFormatEncType(String guid) {
        int tag = 0;
        try {
            tag = Integer.parseInt(guid.substring(0, 8), 16);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        switch (tag) {
            case 1: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.PCM, "PCM audio");
            }
            case 2: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.ADPCM, "ADPCM audio");
            }
            case 3: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.IEEE_FLOAT, "IEEE FLOAT audio");
            }
            case 6: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.ALAW, "aLaw audio");
            }
            case 7: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.MULAW, "muLaw audio");
            }
            case 8: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.DTS, "Digital Theater Systems (DTS) audio");
            }
            case 9: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.DRM, "DRM audio");
            }
            case 10: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.WMSP1, "Windows Media Audio 9 Voice");
            }
            case 17: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.IMA_ADPCM, "IMA ADPCM audio");
            }
            case 34: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.TRUESPEECH, "DSP Group TrueSpeech audio");
            }
            case 48: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.DOLBY_AC2, "Dolby AC2 audio");
            }
            case 49: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.GSM610, "GSM610 audio");
            }
            case 50: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.MNSAUDIO, "MNS Audio");
            }
            case 80: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.MPEG1AUDIO, "MPEG1 audio (MP1/MP2)");
            }
            case 85: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.MPEG1LAYER3, "MPEG1 Layer3 audio (MP3)");
            }
            case 98: 
            case 105: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 129: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.VOXWARE, "Voxware audio");
            }
            case 146: 
            case 304: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.ACELPnet, "Sipro Labs ACELP (voice) audio");
            }
            case 352: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.MSAUDIO1, "MSAudio1");
            }
            case 353: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.WMAUDIO8, "WindowsMedia Audio 7/8");
            }
            case 354: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.WMAUDIO9, "WindowsMedia Audio 9");
            }
            case 355: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.WMAUDIO_LOSSLESS, "WindowsMedia 9 Lossless audio");
            }
            case 576: 
            case 577: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.DOLBY_AC3_SPDIF, "DOLBY AC3 over SPDIF audio");
            }
            case 8192: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.DOLBY_AC3, "Dolby AC3 audio");
            }
            case 26447: 
            case 26448: 
            case 26449: 
            case 26479: 
            case 26480: 
            case 26481: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.VORBIS, "Vorbis audio");
            }
            case 1935960429: {
                return new ACMEnc(guid, tag, EncodingType.Encoding.MIDI, "MIDI");
            }
        }
        return new ACMEnc(guid, tag, EncodingType.Encoding.CUSTOM, "Unknown audio encoding, formatTag: 0x" + Integer.toHexString(tag).toUpperCase());
    }

    static AudioEnc getAudioEncType(String encoding, String filterName) {
        String data1;
        if (encoding == null) {
            String descr = "unknown audio encoding";
            if (filterName != null) {
                descr = descr + ", filter: " + filterName;
            }
            return new AudioEnc(encoding, EncodingType.Encoding.CUSTOM, descr);
        }
        AudioEnc encType = null;
        if (encoding.endsWith("0000-0010-8000-00AA00389B71")) {
            encType = DShowEncodings.getWaveFormatEncType(encoding);
        } else if (encoding.endsWith("524F-11CE-9F53-0020AF0BA770")) {
            data1 = encoding.substring(0, 8);
            if (data1.equals("E436EB80") || data1.equals("E436EB81")) {
                encType = new AudioEnc(encoding, EncodingType.Encoding.MPEG1AUDIO, "MPEG1 audio (MP1/MP2)");
            }
        } else if (encoding.endsWith("DB46-11CF-B4D1-00805F6CBBEA")) {
            data1 = encoding.substring(0, 8);
            if (data1.equals("E06D802B")) {
                encType = new AudioEnc(encoding, EncodingType.Encoding.MPEG2AUDIO, "MPEG2 audio");
            } else if (data1.equals("E06D802C")) {
                encType = new AudioEnc(encoding, EncodingType.Encoding.DOLBY_AC3, "Dolby AC3 audio");
            } else if (data1.equals("E06D8032")) {
                encType = new AudioEnc(encoding, EncodingType.Encoding.DVD_LPCM_AUDIO, "DVD LPCM audio");
            } else if (data1.equals("E06D8033")) {
                encType = new AudioEnc(encoding, EncodingType.Encoding.DTS, "Digital Theater Systems (DTS) audio");
            } else if (data1.equals("E06D8034")) {
                encType = new AudioEnc(encoding, EncodingType.Encoding.SDDS, "Sony Dynamic Digital Sound (SDDS) audio");
            }
        } else if (encoding.equals("CDDCA2D5-6D75-4F98-840E-737BEDD5C63B")) {
            encType = new AudioEnc(encoding, EncodingType.Encoding.VORBIS, "Vorbis audio");
        }
        if (encType == null) {
            String descr = "unknown encoding, filter: " + (filterName == null ? "unknown" : filterName) + ", type: Audio, subtype: " + encoding;
            encType = new AudioEnc(encoding, EncodingType.Encoding.CUSTOM, descr);
        }
        return encType;
    }

    private static FourCCEnc getFourCCEncType(String guid) {
        long fourCC = 0L;
        try {
            fourCC = Long.parseLong(guid.substring(0, 8), 16);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (fourCC <= Integer.MAX_VALUE) {
            switch ((int)fourCC) {
                case 1: 
                case 541214546: 
                case 541215044: 
                case 541412434: 
                case 542263106: 
                case 825307737: 
                case 825308249: 
                case 842094169: 
                case 844715353: 
                case 876956754: 
                case 877417055: 
                case 944065618: 
                case 944525919: 
                case 961893977: 
                case 1094862674: 
                case 1111970399: 
                case 1345401945: 
                case 1413629778: 
                case 1414087263: 
                case 0x55595659: 
                case 0x56595559: 
                case 1463898719: 
                case 0x59565955: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.RAWVIDEO, "Uncompressed video");
                }
                case 842289229: 
                case 844515652: 
                case 859066445: 
                case 877088845: 
                case 1983008845: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.MSMPEG4, "MS MPEG 4 video");
                }
                case 844313677: 
                case 877677894: 
                case 877677906: 
                case 878199880: 
                case 1395937357: 
                case 1446269005: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.ISOMPEG4, "ISO MPEG 4 video");
                }
                case 827544397: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMSCREEN, "Windows Media Screen video");
                }
                case 844321613: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMSCREEN2, "Windows Media Video 9 Screen");
                }
                case 1347833175: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMIMAGE, "Windows Media Video 9 Image");
                }
                case 844125783: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMIMAGE2, "Windows Media Video 9 Image v2");
                }
                case 827739479: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMVIDEO7, "Windows Media Video 7");
                }
                case 844516695: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMVIDEO8, "Windows Media Video 8");
                }
                case 861293911: 
                case 961957207: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMVIDEO9, "Windows Media Video 9");
                }
                case 1096174935: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.WMVIDEO9ADV, "Windows Media Video 9 Advanced Profile");
                }
                case 826496599: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.VC1, "SMPTE 421M standard video (VC-1)");
                }
                case 827738419: 
                case 844515635: 
                case 1482049843: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.THREEIVX, "3IVX video");
                }
                case 827738436: 
                case 861292868: 
                case 878070084: 
                case 894847300: 
                case 911624516: 
                case 1482049860: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.DIVX, "DivX video");
                }
                case 808802372: 
                case 1446268228: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.DIVX5, "DivX5 video");
                }
                case 859189828: 
                case 859189832: 
                case 859189833: 
                case 859189836: 
                case 859189837: 
                case 859189843: 
                case 859189845: 
                case 859189848: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.H263, "H.263 video");
                }
                case 826496577: 
                case 875967048: 
                case 875967064: 
                case 1129726276: 
                case 1213420374: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.H264, "H.264 video");
                }
                case 825381449: 
                case 825381970: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.INDEO2, "Indeo2 video (Real-Time Video 2)");
                }
                case 808670793: 
                case 825448009: 
                case 842225225: 
                case 859002441: 
                case 875779657: 
                case 892556873: 
                case 909334089: 
                case 926111305: 
                case 942888521: 
                case 959665737: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.INDEO3, "Indeo3 video");
                }
                case 541999433: 
                case 808736329: 
                case 825513545: 
                case 842290761: 
                case 859067977: 
                case 875845193: 
                case 892622409: 
                case 909399625: 
                case 926176841: 
                case 942954057: 
                case 959731273: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.INDEO4, "Indeo4 video");
                }
                case 808801865: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.INDEO5, "Indeo video");
                }
                case 1145656920: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.XVID, "XviD video");
                }
                case 1196445016: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.MPEG1VIDEO, "XING MPEG video");
                }
                case 808800342: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.VP5, "On2 VP5 video");
                }
                case 808865878: 
                case 825643094: 
                case 842420310: 
                case 878070854: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.VP6, "On2 VP6 video");
                }
                case 808931414: 
                case 825708630: 
                case 842485846: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.VP7, "On2 VP7 video");
                }
                case 828534116: 
                case 1145656897: 
                case 1196444237: 
                case 1245992513: 
                case 1634757229: 
                case 1651534445: 
                case 1850889793: {
                    return new FourCCEnc(guid, fourCC, EncodingType.Encoding.MJPEG, "Motion JPEG video");
                }
            }
        }
        return new FourCCEnc(guid, fourCC, EncodingType.Encoding.CUSTOM, "Unknown video encoding, fourCC: '" + DShowEncodings.get4CCStr(fourCC) + "'");
    }

    private static String get4CCStr(long fourCC) {
        String s = "";
        for (int shift = 0; shift < 32; shift += 8) {
            s = s + (char)(fourCC >> shift & 0xFFL);
        }
        return s;
    }

    static VideoEnc getVideoEncType(String encoding, String filterName) {
        if (encoding == null) {
            String descr = "unknown video encoding";
            if (filterName != null) {
                descr = descr + ", filter: " + filterName;
            }
            return new VideoEnc(encoding, EncodingType.Encoding.CUSTOM, descr);
        }
        VideoEnc encType = null;
        if (encoding.endsWith("0000-0010-8000-00AA00389B71")) {
            encType = DShowEncodings.getFourCCEncType(encoding);
        } else if (encoding.equals("E06D8026-DB46-11CF-B4D1-00805F6CBBEA")) {
            encType = new VideoEnc(encoding, EncodingType.Encoding.MPEG2VIDEO, "MPEG2 video");
        } else if (encoding.endsWith("524F-11CE-9F53-0020AF0BA770")) {
            long data1 = -1L;
            try {
                data1 = Long.parseLong(encoding.substring(0, 8), 16);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (data1 == 3828804480L || data1 == 3828804481L) {
                encType = new VideoEnc(encoding, EncodingType.Encoding.MPEG1VIDEO, "MPEG1 video");
            } else if (data1 >= 3828804472L && data1 <= 3828804478L) {
                encType = new VideoEnc(encoding, EncodingType.Encoding.RAWVIDEO, "Uncompressed video");
            }
        }
        if (encType == null) {
            String descr = "unknown encoding, filter: " + (filterName == null ? "unknown" : filterName) + ", type: Video, subtype: " + encoding;
            encType = new VideoEnc(encoding, EncodingType.Encoding.CUSTOM, descr);
        }
        return encType;
    }

    static TextEnc getTextEncType(String encoding, String filterName) {
        TextEnc encType = new TextEnc(encoding, EncodingType.Encoding.ANSITEXT, "ANSI plain text");
        return encType;
    }

    static Locale getLocale(String language) {
        Locale locale = language == null ? null : new Locale(language.toLowerCase());
        return locale;
    }

    static class ACMEnc
    extends AudioEnc {
        private final int formatTag;

        ACMEnc(String guid, int fmtTag, EncodingType.Encoding enc, String descr) {
            super(guid, enc, descr);
            this.formatTag = fmtTag;
        }

        int getFormatTag() {
            return this.formatTag;
        }
    }

    static class AudioEnc
    extends EncodingType {
        private String guid;

        AudioEnc(String guid, EncodingType.Encoding enc, String descr) {
            super(enc, descr);
            this.guid = guid;
        }

        String getEncGUID() {
            return this.guid;
        }
    }

    static class FourCCEnc
    extends VideoEnc {
        private final long fourCC;

        FourCCEnc(String guid, long fourCC, EncodingType.Encoding enc, String descr) {
            super(guid, enc, descr);
            this.fourCC = fourCC;
        }

        long getFourCC() {
            return this.fourCC;
        }

        String getFourCCString() {
            return DShowEncodings.get4CCStr(this.fourCC);
        }
    }

    static class TextEnc
    extends EncodingType {
        private String guid;

        TextEnc(String guid, EncodingType.Encoding enc, String descr) {
            super(enc, descr);
            this.guid = guid;
        }

        String getEncGUID() {
            return this.guid;
        }
    }

    static class VideoEnc
    extends EncodingType {
        private String guid;

        VideoEnc(String guid, EncodingType.Encoding enc, String descr) {
            super(enc, descr);
            this.guid = guid;
        }

        String getEncGUID() {
            return this.guid;
        }
    }
}

