/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.directshow.DShowEngine;
import com.sun.media.jmcimpl.plugins.directshow.DShowPlayer;
import com.sun.media.jmcimpl.plugins.directshow.DShowProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DShowMedia
implements MediaPeer {
    private static final int UNKNOWN_TRACK_TYPE = 0;
    private static final int AUDIO_TRACK_TYPE = 1;
    private static final int VIDEO_TRACK_TYPE = 2;
    private static final int TEXT_TRACK_TYPE = 3;
    private static final int MPEG_TRACK_TYPE = 4;
    private static final int MUSIC_TRACK_TYPE = 5;
    private static final int TIME_CODE_TRACK_TYPE = 6;
    protected int width = 0;
    protected int height = 0;
    protected double duration = 0.0;
    protected float fps = 0.0f;
    private URI uri = null;
    private DShowEngine e = null;
    private DShowPlayer p = null;
    private int totalTracks = 0;
    private List<MediaTrack> mediaTracks = null;

    private DShowMedia() {
    }

    public DShowMedia(URI theUri) throws MediaException {
        this();
        this.uri = theUri;
        this.e = DShowEngine.canPlay(this.uri, true);
        this.loadProperties();
    }

    public DShowMedia(DShowPlayer thePlayer, DShowEngine theEngine) {
        this();
        this.e = theEngine;
        this.p = thePlayer;
        this.loadProperties();
        if (null != this.p) {
            this.e = null;
        }
    }

    public DShowMedia(DShowEngine e, URI theURI) {
        this(null, e);
        this.uri = theURI;
    }

    private void loadProperties() {
        if (null == this.e) {
            throw new MediaException("DirectShow does not support this movie format.");
        }
        this.e.getMovieProperties(this);
        this.totalTracks = this.e.getNumTracks(this);
        this.mediaTracks = new ArrayList<MediaTrack>(this.totalTracks);
        for (int i = 0; i < this.totalTracks; ++i) {
            EncodingType encodingType;
            int trackType = this.e.getTrackType(this, i);
            String trackFormat = this.e.getTrackFormat(this, i);
            boolean enabled = this.e.getTrackIsEnabled(this, i);
            if (trackType == 2) {
                encodingType = trackFormat.contains("H.263") ? new EncodingType(EncodingType.Encoding.H263, trackFormat) : (trackFormat.startsWith("H.264") ? new EncodingType(EncodingType.Encoding.H264, trackFormat) : (trackFormat.startsWith("Windows Media Video 9") ? new EncodingType(EncodingType.Encoding.WMVIDEO9, trackFormat) : (trackFormat.contains("Theora") ? new EncodingType(EncodingType.Encoding.THEORA, trackFormat) : (trackFormat.contains("JPEG") ? new EncodingType(EncodingType.Encoding.MJPEG, trackFormat) : new EncodingType(EncodingType.Encoding.CUSTOM, trackFormat)))));
                VideoTrack track = new VideoTrack(encodingType, "Video Track", this.getFrameWidth(), this.getFrameHeight(), this.fps, false);
                this.mediaTracks.add(track);
                continue;
            }
            if (trackType == 1) {
                encodingType = trackFormat.equals("mp4a") ? new EncodingType(EncodingType.Encoding.MPEG4AUDIO, "MPEG-4 Audio") : (trackFormat.contains("Vorbis") ? new EncodingType(EncodingType.Encoding.VORBIS, trackFormat) : (trackFormat.contains("AAC") ? new EncodingType(EncodingType.Encoding.AAC, trackFormat) : (trackFormat.contains("mp3") || trackFormat.contains("MPEG Layer 3") ? new EncodingType(EncodingType.Encoding.MPEG1LAYER3, trackFormat) : (trackFormat.equals("WMA2") ? new EncodingType(EncodingType.Encoding.WMAUDIO8, trackFormat) : (trackFormat.contains("Windows Media Audio 9") ? new EncodingType(EncodingType.Encoding.WMAUDIO9, trackFormat) : (trackFormat.contains("16-bit Integer (Little Endian)") ? new EncodingType(EncodingType.Encoding.PCM, trackFormat) : new EncodingType(EncodingType.Encoding.CUSTOM, trackFormat)))))));
                int channels = this.e.getChannels(this, i);
                long sampleRate = this.e.getSampleRate(this, i);
                AudioTrack track = new AudioTrack(encodingType, "Audio Track", channels, Locale.US, sampleRate);
                this.mediaTracks.add(track);
                continue;
            }
            if (trackType != 3 && trackType != 4 && trackType != 5 && trackType != 6) continue;
        }
    }

    @Override
    public ContainerType getContainerType() {
        ContainerType[] types = DShowProvider.getSupportedContainerTypes();
        String uriString = this.uri.toASCIIString();
        for (int i = 0; i < types.length; ++i) {
            String[] extensions = types[i].getExtensions();
            for (int k = 0; k < extensions.length; ++k) {
                if (!uriString.endsWith(extensions[k])) continue;
                return types[i];
            }
        }
        return null;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public int getFrameWidth() {
        return this.width;
    }

    @Override
    public int getFrameHeight() {
        return this.height;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return null;
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return this.mediaTracks;
    }

    @Override
    public PlayerPeer getPlayerPeer() {
        this.p = null;
        try {
            if (null != this.e) {
                this.p = new DShowPlayer(this, this.e, this.uri);
                this.e = null;
            } else {
                this.p = new DShowPlayer(this.uri);
            }
        }
        catch (MediaException ex) {
            if (this.p != null) {
                this.p.dispose();
                this.p = null;
            }
            throw ex;
        }
        return this.p;
    }
}

