/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.flash;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class BitStream {
    InputStream in;
    int curByte;
    int unreadBits;

    BitStream(InputStream in) {
        this.in = in;
        this.curByte = 0;
        this.unreadBits = 0;
    }

    int read8() throws IOException {
        this.unreadBits = 0;
        int b = this.in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    int read16LE() throws IOException {
        int b1 = this.read8();
        int b2 = this.read8();
        return b1 + (b2 << 8);
    }

    long read32LE() throws IOException {
        long b1 = this.read8();
        long b2 = this.read8();
        long b3 = this.read8();
        long b4 = this.read8();
        return b1 + (b2 << 8) + (b3 << 16) + (b4 << 24);
    }

    int read16BE() throws IOException {
        int b1 = this.read8();
        int b2 = this.read8();
        return (b1 << 8) + b2;
    }

    long read32() throws IOException {
        long b1 = this.read8();
        long b2 = this.read8();
        long b3 = this.read8();
        long b4 = this.read8();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    private void readNextByte() throws IOException {
        this.curByte = this.read8();
        this.unreadBits = 8;
    }

    boolean readBit() throws IOException {
        if (this.unreadBits <= 0) {
            this.readNextByte();
        }
        --this.unreadBits;
        return 0 != (this.curByte & 1 << this.unreadBits);
    }

    long readBits(int bits, boolean signed) throws IOException {
        long signBit;
        if (bits <= 0) {
            return 0L;
        }
        long mask = (1L << bits) - 1L;
        if (this.unreadBits <= 0) {
            this.readNextByte();
        }
        long result = this.curByte;
        bits -= this.unreadBits;
        while (bits > 0) {
            this.readNextByte();
            result <<= 8;
            result |= (long)this.curByte;
            bits -= 8;
        }
        this.unreadBits = -bits;
        result >>= this.unreadBits;
        if (signed && ((result &= mask) & (signBit = mask + 1L >> 1)) != 0L) {
            result |= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }
}

