/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.flash;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.flash.BitStream;
import com.sun.media.jmcimpl.plugins.flash.FlashProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlashMedia
implements MediaPeer {
    static final int DEFAULT_WIDTH = 320;
    static final int DEFAULT_HEIGHT = 240;
    int flashVersionRequired = -1;
    int width = 320;
    int height = 240;
    double duration = Double.NEGATIVE_INFINITY;
    float frameRate = -1.0f;
    ContainerType containerType = null;
    Map<String, Object> metadata = new HashMap<String, Object>();
    List<MediaTrack> tracks = new ArrayList<MediaTrack>(1);

    FlashMedia(URI uri) throws MediaException {
        InputStream inStream = this.openStream(uri);
        inStream = new BufferedInputStream(inStream, 256);
        inStream.mark(256);
        if (this.loadSWF(inStream)) {
            return;
        }
        try {
            inStream.reset();
        }
        catch (IOException ex) {
            inStream = this.openStream(uri);
        }
        if (this.loadFLV(inStream)) {
            return;
        }
        throw new MediaUnsupportedException();
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public int getFrameWidth() {
        return this.width;
    }

    @Override
    public int getFrameHeight() {
        return this.height;
    }

    private InputStream openStream(URI uri) throws MediaException {
        try {
            return uri.toURL().openStream();
        }
        catch (IOException ex) {
            throw new MediaUnavailableException("Could not open media", ex);
        }
    }

    boolean loadSWF(InputStream in) {
        try {
            BitStream stream = new BitStream(in);
            int sig1 = stream.read8();
            int sig2 = stream.read8();
            int sig3 = stream.read8();
            if (sig1 != 70 && sig1 != 67 || sig2 != 87 || sig3 != 83) {
                return false;
            }
            this.flashVersionRequired = stream.read8();
            this.containerType = FlashProvider.SWFContainer;
            this.metadata.put("flashVersion", new Integer(this.flashVersionRequired));
            this.tracks.add(new SWFTrack());
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    boolean loadFLV(InputStream in) {
        return false;
    }

    @Override
    public PlayerPeer getPlayerPeer() {
        return null;
    }

    class SWFTrack
    extends VideoTrack {
        public SWFTrack() {
            super(new EncodingType(EncodingType.Encoding.CUSTOM, "Flash encoding"), "Flash Track", FlashMedia.this.width, FlashMedia.this.height, FlashMedia.this.frameRate, false);
        }
    }
}

