/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.flash;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.OperationUnsupportedException;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.event.MediaEvent;
import com.sun.media.jmc.event.MediaStateEvent;
import com.sun.media.jmc.event.VideoRendererEvent;
import com.sun.media.jmcimpl.MediaNetworkProvider;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.flash.FlashMedia;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlashPlayer
implements PlayerPeer {
    private static final boolean trace = false;
    private final boolean useEDT = true;
    private long id = 0L;
    private BlockingQueue<MediaEvent> eventQueue = null;
    private FlashMedia mediaPeer = null;
    private MonitorThread monitorThread = new MonitorThread();
    private Set<PlayerPeer.Capabilities> caps = null;
    private static final int eventContentUpdated = 1;
    private static final int eventReadyStateChanged = 2;
    private static final long MonitorThreadWaitDelay = 50L;

    public FlashPlayer() throws MediaException {
        this(true);
    }

    public FlashPlayer(boolean lightweight) throws MediaException {
        this.id = this.nCreate(lightweight);
        if (this.id == 0L) {
            throw new MediaException("Could not create native Flash object");
        }
        this.monitorThread.start();
        this.nSetBGColor(this.id, 0);
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.id != 0L) {
            this.nFinalize(this.id);
            this.id = 0L;
        }
    }

    @Override
    public void setSource(URI uri) throws MediaException {
        if (this.id == 0L) {
            throw new MediaUnsupportedException("no native Flash object");
        }
        this.mediaPeer = new FlashMedia(uri);
        int ver = this.nGetFlashVersion(this.id);
        int verMajor = ver >> 16;
        int verMinor = ver & 0xFFFF;
        if (this.mediaPeer.flashVersionRequired > verMajor) {
            throw new MediaUnsupportedException("the media requires Flash " + this.mediaPeer.flashVersionRequired + ", currently installed Flash " + verMajor + "." + verMinor);
        }
        this.updateSize(this.mediaPeer.width, this.mediaPeer.height);
        if (!this.nSetSource(this.id, uri.toASCIIString())) {
            throw new MediaException("can't open specified URI");
        }
        this.nStop(this.id);
    }

    @Override
    public void dispose() {
        if (this.id != 0L) {
            this.nFinalize(this.id);
            this.id = 0L;
        }
    }

    @Override
    public void start() {
        if (this.id != 0L) {
            this.nStart(this.id);
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
        if (this.id != 0L) {
            this.nStop(this.id);
        }
    }

    @Override
    public void setMediaTime(double time) throws MediaException {
        if (time == 0.0 && this.id != 0L) {
            this.nRewind(this.id);
        }
    }

    @Override
    public double getMediaTime() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setStartTime(double time) throws MediaException {
        if (time == 0.0) {
            // empty if block
        }
    }

    @Override
    public double getStartTime() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setStopTime(double time) throws MediaException {
    }

    @Override
    public double getStopTime() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getDuration() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int getFrameWidth() {
        return this.mediaPeer.width;
    }

    @Override
    public int getFrameHeight() {
        return this.mediaPeer.height;
    }

    @Override
    public void setRate(double rate) {
    }

    @Override
    public double getRate() {
        return 1.0;
    }

    @Override
    public void setVolume(float volume) {
    }

    @Override
    public float getVolume() {
        return 1.0f;
    }

    @Override
    public void setBalance(float balance) {
    }

    @Override
    public float getBalance() {
        return 0.0f;
    }

    @Override
    public void setFader(float fader) {
    }

    @Override
    public float getFader() {
        return 0.0f;
    }

    @Override
    public void setEventQueue(BlockingQueue<MediaEvent> queue) {
        this.eventQueue = queue;
    }

    @Override
    public void setNotificationTimes(List<Double> list) {
        if (!list.isEmpty()) {
            throw new OperationUnsupportedException();
        }
    }

    @Override
    public void setAutoRepeat(boolean autoRepeat) {
        if (this.id != 0L) {
            this.nSetAutoRepeat(this.id, autoRepeat);
        }
    }

    @Override
    public MediaPeer getMediaPeer() {
        return this.mediaPeer;
    }

    @Override
    public Set<PlayerPeer.Capabilities> getCapabilities() {
        if (this.caps == null) {
            this.caps = EnumSet.noneOf(PlayerPeer.Capabilities.class);
            this.caps.add(PlayerPeer.Capabilities.isLightweight);
            this.caps = Collections.unmodifiableSet(this.caps);
        }
        return this.caps;
    }

    private void sendMediaEvent(MediaEvent event) {
        if (this.eventQueue != null) {
            this.eventQueue.offer(event);
        }
    }

    private void sendMediaEvent(int eventID) {
        switch (eventID) {
            case 1: {
                this.doRepaint();
                this.sendMediaEvent(new VideoRendererEvent(Double.NEGATIVE_INFINITY, "content updated", this, -1));
                break;
            }
            case 2: {
                if (this.id == 0L) break;
                int[] size = new int[2];
                if (!this.nGetMovieSize(this.id, size)) {
                    size[0] = 320;
                    size[0] = 240;
                }
                if (this.mediaPeer.width == size[0] && this.mediaPeer.height == size[1]) break;
                this.updateSize(size[0], size[1]);
            }
        }
    }

    private void updateSize(int width, int height) {
    }

    private void doRepaint() {
    }

    @Override
    public void getFrameData(VideoDataBuffer data) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public void releaseFrameData(VideoDataBuffer data) {
    }

    @Override
    public void setResizeBehavior(VideoControl.ResizeBehavior behavior) {
        switch (behavior) {
            case None: {
                this.nSetScaleMode(this.id, 3);
                break;
            }
            case Preserve: {
                this.nSetScaleMode(this.id, 0);
                break;
            }
            case Stretch: {
                this.nSetScaleMode(this.id, 2);
            }
        }
    }

    private static native boolean nInit();

    private native long nCreate(boolean var1);

    private native void nFinalize(long var1);

    private native boolean nIsWindowless(long var1);

    private native boolean nSetSource(long var1, String var3);

    private native boolean nStart(long var1);

    private native boolean nStop(long var1);

    private native boolean nRewind(long var1);

    private native void nSetAutoRepeat(long var1, boolean var3);

    private native boolean nGetAutoRepeat(long var1);

    private native void nSetScaleMode(long var1, int var3);

    private native void nSetBGColor(long var1, int var3);

    private native void nSetBounds(long var1, int var3, int var4, int var5, int var6);

    private native void nSetVisible(long var1, boolean var3);

    private native int nGetReadyState(long var1);

    private native boolean nIsPlaying(long var1);

    private native long nGetFrameNumber(long var1);

    private native long nGetFramePos(long var1);

    private native boolean nGetMovieSize(long var1, int[] var3);

    private native int nGetFlashVersion(long var1);

    private native int[] nGetImage(long var1, int var3, int var4);

    static {
        if (!FlashPlayer.nInit()) {
            throw new MediaException("could not initialize FlashPlayer native lib");
        }
        MediaNetworkProvider.activate();
    }

    private class MonitorThread
    extends Thread {
        MonitorThread() {
            super("FlashPlayer monitor thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int ticker = 50;
            boolean wasPlaying = false;
            while (FlashPlayer.this.id != 0L) {
                boolean playing = FlashPlayer.this.nIsPlaying(FlashPlayer.this.id);
                if (playing ^ wasPlaying) {
                    wasPlaying = playing;
                    if (playing) {
                        FlashPlayer.this.sendMediaEvent(new MediaStateEvent(Double.NEGATIVE_INFINITY, "started", this, MediaStateEvent.MediaState.STARTED));
                    } else {
                        FlashPlayer.this.sendMediaEvent(new MediaStateEvent(Double.NEGATIVE_INFINITY, "stopped", this, MediaStateEvent.MediaState.STOPPED));
                    }
                }
                try {
                    MonitorThread monitorThread = this;
                    synchronized (monitorThread) {
                        this.wait(50L);
                    }
                }
                catch (InterruptedException ex) {
                }
            }
        }
    }

    private static class ScaleMode {
        public static final int ShowAll = 0;
        public static final int NoBorder = 1;
        public static final int ExactFit = 2;
        public static final int NoScale = 3;

        private ScaleMode() {
        }
    }
}

