/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaInfo;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTPlayerProvider;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTStreamInfo;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTUtils;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSTMediaPeer
implements MediaPeer {
    private static final Map<URI, GSTMediaPeer> cache = new MediaInfoCache();
    private List<MediaTrack> trackInfo;
    private Map<String, Object> metadata;
    private double duration = Double.POSITIVE_INFINITY;
    private int videoWidth;
    private int videoHeight;
    private ContainerType containerType;

    private static native GSTMediaInfo nativeGetMediaInfo(String var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GSTMediaPeer getMediaPeer(URI uri) {
        Map<URI, GSTMediaPeer> map = cache;
        synchronized (map) {
            if (cache.containsKey(uri)) {
                return cache.get(uri);
            }
        }
        GSTMediaInfo mediaInfo = GSTMediaPeer.nativeGetMediaInfo(GSTUtils.normalize(uri).toString(), 10);
        return GSTMediaPeer.createMediaPeer(uri, mediaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GSTMediaPeer createMediaPeer(URI uri, GSTMediaInfo mediaInfo) {
        GSTMediaPeer result = null;
        if (mediaInfo != null) {
            result = new GSTMediaPeer(mediaInfo);
            Map<URI, GSTMediaPeer> map = cache;
            synchronized (map) {
                cache.put(uri, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasBeenCached(URI uri) {
        Map<URI, GSTMediaPeer> map = cache;
        synchronized (map) {
            return cache.containsKey(uri);
        }
    }

    private GSTMediaPeer(GSTMediaInfo mediaInfo) {
        this.initInstance(mediaInfo);
    }

    private void initInstance(GSTMediaInfo mediaInfo) {
        this.trackInfo = new LinkedList<MediaTrack>();
        block4: for (GSTStreamInfo stream : mediaInfo.getStreamInfo()) {
            switch (stream.getStreamType()) {
                case AUDIO: {
                    GSTStreamInfo.Audio aStream = (GSTStreamInfo.Audio)stream;
                    EncodingType encoding = new EncodingType(GSTUtils.getEncoding(stream), "GStreamer encoding type: " + aStream.getMimeType());
                    AudioTrack aTrack = new AudioTrack(encoding, "Audio Track", aStream.getChannels(), Locale.US, aStream.getRate());
                    this.trackInfo.add(aTrack);
                    continue block4;
                }
                case VIDEO: {
                    GSTStreamInfo.Video vStream = (GSTStreamInfo.Video)stream;
                    EncodingType encoding = new EncodingType(GSTUtils.getEncoding(stream), "GStreamer encoding type: " + vStream.getMimeType());
                    VideoTrack vTrack = new VideoTrack(encoding, "Video Track", vStream.getWidth(), vStream.getHeight(), (float)vStream.getFramerate(), false);
                    this.trackInfo.add(vTrack);
                    if (vStream.isSizeValid()) {
                        this.videoWidth = vStream.getWidth();
                        this.videoHeight = vStream.getHeight();
                        continue block4;
                    }
                    this.videoHeight = 0;
                    this.videoWidth = 0;
                    continue block4;
                }
            }
        }
        this.metadata = mediaInfo.getMetadata();
        this.containerType = new ContainerType(GSTUtils.getContainer(mediaInfo.getMimeType()), "GStreamer container type: " + mediaInfo.getMimeType(), GSTPlayerProvider.getTypesList().get(mediaInfo.getMimeType()), new String[]{mediaInfo.getMimeType()});
        this.duration = GSTUtils.toSeconds(mediaInfo.getDuration());
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return this.trackInfo;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata == null ? null : Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public int getFrameWidth() {
        return this.videoWidth;
    }

    @Override
    public int getFrameHeight() {
        return this.videoHeight;
    }

    @Override
    public PlayerPeer getPlayerPeer() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MediaInfoCache
    extends LinkedHashMap<URI, GSTMediaPeer> {
        private static final int CACHE_SIZE = 50;

        MediaInfoCache() {
            super(20, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<URI, GSTMediaPeer> eldest) {
            return this.size() > 50;
        }
    }
}

