/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.spi;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultPlayerPeerProvider
implements PlayerPeerProvider {
    protected ContainerType[] supportedTypes;
    protected PlayerPeerProvider.PlaybackMode playbackMode;

    protected DefaultPlayerPeerProvider(ContainerType[] supportedTypes, PlayerPeerProvider.PlaybackMode playbackMode) {
        this.supportedTypes = supportedTypes;
        this.playbackMode = playbackMode;
    }

    @Override
    public ContainerType[] getContainerTypes() {
        return this.supportedTypes;
    }

    @Override
    public PlayerPeerProvider.PlaybackMode canPlay(URI uri, VideoDataBuffer.Format[] formats) {
        return DefaultPlayerPeerProvider.isSupportedType(this.getContainerTypes(), uri) ? this.playbackMode : PlayerPeerProvider.PlaybackMode.None;
    }

    @Override
    public abstract PlayerPeer createPlayerPeer(URI var1, VideoDataBuffer.Format[] var2) throws MediaException;

    @Override
    public abstract Class<? extends PlayerPeer> getPlayerPeerClass();

    static boolean isSupportedType(ContainerType[] supportedTypes, URI uri) {
        String path;
        int pointPos;
        URI theURI;
        String contentType;
        if (uri.toASCIIString().toLowerCase().startsWith("http:") && (contentType = (String)AccessController.doPrivileged(new PrivilegedAction(theURI = uri){
            final /* synthetic */ URI val$theURI;
            {
                this.val$theURI = uRI;
            }

            public Object run() {
                try {
                    URL theURL = this.val$theURI.toURL();
                    URLConnection conn = theURL.openConnection();
                    return conn.getContentType();
                }
                catch (MalformedURLException e) {
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
        })) != null) {
            for (int i = 0; i < supportedTypes.length; ++i) {
                String[] mimeTypes = supportedTypes[i].getMimeTypes();
                for (int j = 0; j < mimeTypes.length; ++j) {
                    if (!contentType.equals(mimeTypes[j])) continue;
                    return true;
                }
            }
        }
        if ((pointPos = (path = uri.toASCIIString()).lastIndexOf(".")) >= 0) {
            String extension = path.substring(pointPos + 1).toLowerCase();
            for (int i = 0; i < supportedTypes.length; ++i) {
                String[] extensions = supportedTypes[i].getExtensions();
                for (int j = 0; j < extensions.length; ++j) {
                    if (!extension.equals(extensions[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

