/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import net.sf.sockettest.NetService;
import net.sf.sockettest.Util;
import net.sf.sockettest.swing.SocketTestClient;
import net.sf.sockettest.swing.SocketTestServer;
import net.sf.sockettest.swing.SocketTestUdp;

public class SocketTest
extends JFrame {
    private static final String CLIENT = "c";
    private static final String SERVER = "s";
    private static final String UDP = "u";
    private ClassLoader cl = this.getClass().getClassLoader();
    public ImageIcon logo = new ImageIcon(this.cl.getResource("icons/logo.gif"));
    public ImageIcon ball = new ImageIcon(this.cl.getResource("icons/ball.gif"));
    private JTabbedPane tabbedPane;
    public static Map<String, NetService> services = new HashMap<String, NetService>();
    public SocketTestClient client;
    public SocketTestServer server;
    public SocketTestUdp udp;

    public SocketTest() {
        this.setTitle("SocketTest v 3.0.1");
        this.setSize(600, 500);
        Util.centerWindow(this);
        Container container = this.getContentPane();
        this.tabbedPane = new JTabbedPane(1);
        this.client = new SocketTestClient(this);
        this.server = new SocketTestServer(this);
        this.udp = new SocketTestUdp(this);
        services.put(CLIENT, this.client);
        services.put(SERVER, this.server);
        services.put(UDP, this.udp);
        this.tabbedPane.addTab("Client", this.ball, this.client, "Test any server");
        this.tabbedPane.addTab("Server", this.ball, this.server, "Test any client");
        this.tabbedPane.addTab("Udp", this.ball, this.udp, "Test any UDP Client or Server");
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add(this.tabbedPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SocketTest.this.close();
            }
        });
    }

    private static void setUpArgParams(String[] stringArray) {
        if (stringArray.length < 1) {
            return;
        }
        for (String string : stringArray) {
            String[] stringArray2 = string.split(":");
            if (stringArray2.length != 3) continue;
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            services.get(string2).setUpConfiguration(string3, string4);
        }
    }

    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.udp.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

