/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import net.sf.sockettest.NetService;
import net.sf.sockettest.UdpServer;
import net.sf.sockettest.Util;
import net.sf.sockettest.swing.PortDialog;

public class SocketTestUdp
extends JPanel
implements NetService {
    private final String NEW_LINE = "\r\n";
    private ClassLoader cl = this.getClass().getClassLoader();
    public ImageIcon logo = new ImageIcon(this.cl.getResource("icons/logo.gif"));
    private JPanel northPanel;
    private JPanel serverPanel;
    private JPanel convPanel;
    private JPanel clientPanel;
    private JPanel buttonPanel;
    private JLabel ipLabel1 = new JLabel("IP Address");
    private JLabel portLabel1 = new JLabel("Port");
    private JLabel logoLabel = new JLabel("SocketTest v 3.0", this.logo, 0);
    private JTextField ipField1 = new JTextField("0.0.0.0", 20);
    private JTextField portField1 = new JTextField("21", 5);
    private JButton portButton1 = new JButton("Port");
    private JButton connectButton = new JButton("Start Listening");
    private Border convBorder = BorderFactory.createTitledBorder(new EtchedBorder(), "Conversation");
    private JTextArea messagesField = new JTextArea();
    private JLabel ipLabel2 = new JLabel("IP Address");
    private JLabel portLabel2 = new JLabel("Port");
    private JTextField ipField2 = new JTextField("127.0.0.1");
    private JTextField portField2 = new JTextField("21", 5);
    private JButton portButton2 = new JButton("Port");
    private JLabel sendLabel = new JLabel("Message");
    private JTextField sendField = new JTextField();
    private JButton sendButton = new JButton("Send");
    private JButton saveButton = new JButton("Save");
    private JButton clearButton = new JButton("Clear");
    private GridBagConstraints gbc = new GridBagConstraints();
    private DatagramSocket server;
    private DatagramSocket client;
    private DatagramPacket packet;
    private UdpServer udpServer;
    private DatagramPacket pack;
    private byte[] buffer;
    protected final JFrame parent;

    public SocketTestUdp(final JFrame jFrame) {
        this.parent = jFrame;
        SocketTestUdp socketTestUdp = this;
        this.northPanel = new JPanel();
        this.serverPanel = new JPanel();
        this.serverPanel.setLayout(new GridBagLayout());
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.serverPanel.add((Component)this.ipLabel1, this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 2;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestUdp.this.portField1.requestFocus();
            }
        };
        this.ipField1.addActionListener(actionListener);
        this.serverPanel.add((Component)this.ipField1, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.serverPanel.add((Component)this.portLabel1, this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestUdp.this.listen();
            }
        };
        this.portField1.addActionListener(actionListener2);
        this.serverPanel.add((Component)this.portField1, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.portButton1.setMnemonic('P');
        this.portButton1.setToolTipText("View Standard Ports");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PortDialog portDialog = new PortDialog(jFrame, 1);
                portDialog.show();
            }
        };
        this.portButton1.addActionListener(actionListener3);
        this.serverPanel.add((Component)this.portButton1, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 3;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.connectButton.setMnemonic('S');
        this.connectButton.setToolTipText("Start Listening");
        this.connectButton.addActionListener(actionListener2);
        this.serverPanel.add((Component)this.connectButton, this.gbc);
        this.serverPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Server"));
        this.northPanel.setLayout(new BorderLayout(10, 0));
        this.northPanel.add(this.serverPanel);
        this.logoLabel.setVerticalTextPosition(3);
        this.logoLabel.setHorizontalTextPosition(0);
        this.northPanel.add((Component)this.logoLabel, "East");
        this.northPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.convPanel = new JPanel();
        this.convPanel.setLayout(new BorderLayout(0, 5));
        this.messagesField.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.messagesField);
        this.convPanel.add(jScrollPane);
        this.convPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), this.convBorder));
        this.clientPanel = new JPanel();
        this.clientPanel.setLayout(new GridBagLayout());
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.clientPanel.add((Component)this.ipLabel2, this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestUdp.this.portField2.requestFocus();
            }
        };
        this.ipField2.addActionListener(actionListener4);
        this.clientPanel.add((Component)this.ipField2, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 0;
        this.gbc.gridx = 2;
        this.gbc.fill = 0;
        this.clientPanel.add((Component)this.portLabel2, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 0;
        this.gbc.gridx = 3;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestUdp.this.sendField.requestFocus();
            }
        };
        this.portField2.addActionListener(actionListener5);
        this.clientPanel.add((Component)this.portField2, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 0;
        this.gbc.gridx = 4;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        this.portButton2.setMnemonic('P');
        this.portButton2.setToolTipText("View Standard Ports");
        this.portButton2.addActionListener(actionListener3);
        this.clientPanel.add((Component)this.portButton2, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.clientPanel.add((Component)this.sendLabel, this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 2;
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SocketTestUdp.this.sendField.getText();
                if (!string.equals("")) {
                    SocketTestUdp.this.sendMessage(string);
                } else {
                    int n = JOptionPane.showConfirmDialog(SocketTestUdp.this, "Send Blank Line ?", "Send Data To Server", 0);
                    if (n == 0) {
                        SocketTestUdp.this.sendMessage(string);
                    }
                }
            }
        };
        this.sendField.addActionListener(actionListener6);
        this.clientPanel.add((Component)this.sendField, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 4;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        this.sendButton.addActionListener(actionListener6);
        this.clientPanel.add((Component)this.sendButton, this.gbc);
        this.clientPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3), BorderFactory.createTitledBorder("Client")));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 2;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.gbc.fill = 1;
        this.buttonPanel.add((Component)this.clientPanel, this.gbc);
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbc.fill = 2;
        this.saveButton.setToolTipText("Save conversation with client to a file");
        this.saveButton.setMnemonic('S');
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SocketTestUdp.this.messagesField.getText();
                if (string.equals("")) {
                    SocketTestUdp.this.error("Nothing to save", "Save to file");
                    return;
                }
                String string2 = "";
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("."));
                int n = jFileChooser.showSaveDialog(SocketTestUdp.this);
                if (n == 0) {
                    string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                    try {
                        Util.writeFile(string2, string);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(SocketTestUdp.this, exception.getMessage(), "Error saving to file..", 0);
                    }
                }
            }
        };
        this.saveButton.addActionListener(actionListener7);
        this.buttonPanel.add((Component)this.saveButton, this.gbc);
        this.gbc.gridy = 1;
        this.clearButton.setToolTipText("Clear conversation with client");
        this.clearButton.setMnemonic('C');
        ActionListener actionListener8 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestUdp.this.messagesField.setText("");
            }
        };
        this.clearButton.addActionListener(actionListener8);
        this.buttonPanel.add((Component)this.clearButton, this.gbc);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        socketTestUdp.setLayout(new BorderLayout(10, 0));
        socketTestUdp.add((Component)this.northPanel, "North");
        socketTestUdp.add((Component)this.convPanel, "Center");
        socketTestUdp.add((Component)this.buttonPanel, "South");
    }

    private void listen() {
        if (this.server != null) {
            this.stop();
            return;
        }
        String string = this.ipField1.getText();
        String string2 = this.portField1.getText();
        if (string == null || string.equals("")) {
            JOptionPane.showMessageDialog(this, "No IP Address. Please enter IP Address", "Error connecting", 0);
            this.ipField1.requestFocus();
            this.ipField1.selectAll();
            return;
        }
        if (string2 == null || string2.equals("")) {
            JOptionPane.showMessageDialog(this, "No Port number. Please enter Port number", "Error connecting", 0);
            this.portField1.requestFocus();
            this.portField1.selectAll();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!Util.checkHost(string)) {
            JOptionPane.showMessageDialog(this, "Bad IP Address", "Error connecting", 0);
            this.ipField1.requestFocus();
            this.ipField1.selectAll();
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Bad Port number. Please enter Port number", "Error connecting", 0);
            this.portField1.requestFocus();
            this.portField1.selectAll();
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        boolean bl = false;
        try {
            InetAddress inetAddress = null;
            int n2 = string.indexOf(".");
            int n3 = 0;
            if (n2 != -1) {
                n3 = Integer.parseInt(string.substring(0, n2));
            }
            if (n3 >= 224 && n3 <= 239) {
                MulticastSocket multicastSocket = new MulticastSocket(n);
                multicastSocket.joinGroup(InetAddress.getByName(string));
                this.server = multicastSocket;
                bl = true;
            } else if (!string.equals("0.0.0.0")) {
                inetAddress = InetAddress.getByName(string);
                this.server = new DatagramSocket(n, inetAddress);
            } else {
                inetAddress = null;
                this.server = new DatagramSocket(n);
            }
            this.ipField1.setEditable(false);
            this.portField1.setEditable(false);
            this.connectButton.setText("Stop Listening");
            this.connectButton.setMnemonic('S');
            this.connectButton.setToolTipText("Stop Listening");
        }
        catch (Exception exception) {
            this.error(exception.getMessage(), "Starting Server at " + n);
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (bl) {
            this.messagesField.setText("> MultiCase Server Joined on Port : " + n + "\r\n");
        } else {
            this.messagesField.setText("> Server Started on Port : " + n + "\r\n");
        }
        this.append("> ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.udpServer = UdpServer.handle(this, this.server);
    }

    public synchronized void stop() {
        try {
            this.udpServer.setStop(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        this.ipField1.setEditable(true);
        this.portField1.setEditable(true);
        this.connectButton.setText("Start Listening");
        this.connectButton.setMnemonic('S');
        this.connectButton.setToolTipText("Start Listening");
        this.append("> Server stopped");
        this.append("> ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public void sendMessage(String string) {
        try {
            String string2 = this.ipField2.getText();
            String string3 = this.portField2.getText();
            if (string2 == null || string2.equals("")) {
                JOptionPane.showMessageDialog(this, "No IP Address. Please enter IP Address", "Error connecting", 0);
                this.ipField2.requestFocus();
                this.ipField2.selectAll();
                return;
            }
            if (string3 == null || string3.equals("")) {
                JOptionPane.showMessageDialog(this, "No Port number. Please enter Port number", "Error connecting", 0);
                this.portField2.requestFocus();
                this.portField2.selectAll();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!Util.checkHost(string2)) {
                JOptionPane.showMessageDialog(this, "Bad IP Address", "Error connecting", 0);
                this.ipField2.requestFocus();
                this.ipField2.selectAll();
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Bad Port number. Please enter Port number", "Error connecting", 0);
                this.portField2.requestFocus();
                this.portField2.selectAll();
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            InetAddress inetAddress = null;
            inetAddress = InetAddress.getByName(string2);
            if (this.client == null) {
                this.client = new DatagramSocket();
                UdpServer.handleClient(this, this.client);
            }
            this.buffer = string.getBytes();
            this.pack = new DatagramPacket(this.buffer, this.buffer.length, inetAddress, n);
            this.append("S[" + inetAddress.getHostAddress() + ":" + n + "]: " + string);
            this.client.send(this.pack);
            this.sendField.setText("");
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error Sending Message", 0);
            this.client = null;
        }
    }

    public void error(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public void error(String string, String string2) {
        if (string == null || string.equals("")) {
            return;
        }
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    public void append(String string) {
        this.messagesField.append(string + "\r\n");
        this.messagesField.setCaretPosition(this.messagesField.getText().length());
    }

    @Override
    public void setUpConfiguration(String string, String string2) {
        this.ipField1.setText(string);
        this.portField1.setText(string2);
        this.ipField2.setText(string);
        this.portField2.setText(string2);
    }
}

