/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppitf.gamepad.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.sportdata.setppitf.anzeige.AnzeigeController;
import org.sportdata.setppitf.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppitf.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppitf.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppitf.anzeige.utils.FehlerFenster;
import org.sportdata.setppitf.anzeige.utils.OptionWindow;
import org.sportdata.setppitf.gamepad.GamePadLoader;
import org.sportdata.setppitf.gamepad.component.renderer.StatusComboBoxRenderer;
import org.sportdata.setppitf.swing.components.FadeGamepadInactivePopup;

public class GamePadPanel
extends JPanel
implements IAnzeigeEventListener {
    private static final long serialVersionUID = 5680469708544054242L;
    private AnzeigeController a;
    private boolean b;
    private int c;
    private GamePadLoader d;
    private JXTable e;
    private DefaultTableModel f;
    private Vector<String> g;
    private Vector<Vector<Object>> h;
    private JButton i;
    private JButton j;
    private TableModelListener k;
    private JComboBox<String> l;
    public static final String NEW = "NEW";
    public static final String ACTIVE_UNASSIGNED = "ACTIVE UNASSIGNED";
    public static final String ACTIVE_ASSIGNED = "ACTIVE ASSIGNED";
    public static final String INACTIVE = "INACTIVE";
    private JCheckBox m;
    private FadeGamepadInactivePopup n;

    public GamePadPanel(AnzeigeController acontrol, int mode, boolean logging) {
        this.c = mode;
        this.a = acontrol;
        this.b = logging;
        this.registerPanel();
        this.d = new GamePadLoader(acontrol, mode);
        this.b();
        this.e();
        this.f();
        this.a();
        this.g();
        if (AnzeigePropertiesHelper.getPpenablegamepad().equals("true")) {
            try {
                new SwingWorker<String, Void>(){

                    protected String a() {
                        GamePadPanel.this.d.searchForControllers();
                        GamePadPanel.this.d.loadRefereesFromProps();
                        return "";
                    }

                    @Override
                    protected void done() {
                        GamePadPanel.this.updateTableData();
                    }

                    @Override
                    protected /* synthetic */ Object doInBackground() throws Exception {
                        return this.a();
                    }
                }.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.e), "Center");
        JPanel psouth = new JPanel();
        this.i = new JButton("Refresh");
        this.i.setIcon(new ImageIcon("images/Re1.gif"));
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GamePadPanel.this.updateTableData();
            }
        });
        this.j = new JButton("Reload Device List");
        this.j.setIcon(new ImageIcon("images/gifcon2.gif"));
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionWindow.optionShow(AnzeigeResource.getResourceString("gamepad.reload.question"), null) == 0) {
                    try {
                        new SwingWorker<String, Void>(){

                            protected String a() {
                                (this).GamePadPanel.this.d.searchForControllers();
                                (this).GamePadPanel.this.d.loadRefereesFromProps();
                                return "";
                            }

                            @Override
                            protected void done() {
                                GamePadPanel.this.updateTableData();
                            }

                            @Override
                            protected /* synthetic */ Object doInBackground() throws Exception {
                                return this.a();
                            }
                        }.execute();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.m = new JCheckBox("Enable");
        if (AnzeigePropertiesHelper.getPpenablegamepad().equals("true")) {
            this.m.setSelected(true);
            this.i.setEnabled(true);
            this.j.setEnabled(true);
        } else {
            this.m.setSelected(false);
            this.i.setEnabled(false);
            this.j.setEnabled(false);
        }
        this.m.setActionCommand(AnzeigeResource.getResourceString("setting.color.id"));
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (GamePadPanel.this.m.isSelected()) {
                        AnzeigePropertiesHelper.setPpenablegamepad("true");
                        GamePadPanel.this.i.setEnabled(true);
                        GamePadPanel.this.j.setEnabled(true);
                        GamePadPanel.this.j.doClick();
                    } else {
                        AnzeigePropertiesHelper.setPpenablegamepad("false");
                        GamePadPanel.this.d.stopAllGamepads();
                        GamePadPanel.this.d.removeAllControllers();
                        GamePadPanel.this.i.doClick();
                        GamePadPanel.this.i.setEnabled(false);
                        GamePadPanel.this.j.setEnabled(false);
                        GamePadPanel.this.d();
                    }
                    AnzeigePropertiesHelper.saveAnzeigeProps();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        psouth.add(this.m);
        psouth.add(this.i);
        psouth.add(this.j);
        this.add((Component)psouth, "South");
    }

    private void b() {
        this.h = new Vector();
        this.g = new Vector();
        this.g.add("Device");
        this.g.add("Referee");
        this.g.add("Button Score RED");
        this.g.add("Button Score BLUE");
        this.g.add("Status");
        this.f = new DefaultTableModel(this.h, this.g){
            private static final long serialVersionUID = 4231289093517984959L;
            Class[] a;
            boolean[] b;
            {
                this.a = new Class[]{String.class, String.class, String.class, String.class, String.class};
                boolean[] blArray = new boolean[5];
                blArray[1] = true;
                this.b = blArray;
            }

            public Class getColumnClass(int columnIndex) {
                return this.a[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.b[columnIndex];
            }
        };
        this.e = new JXTable((TableModel)this.f);
        this.e.setTableHeader(new JTableHeader(this.e.getColumnModel()){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return GamePadPanel.this.g.get(realIndex);
            }
        });
        this.e.setAutoResizeMode(4);
        this.e.getTableHeader().setReorderingAllowed(false);
        this.e.setSelectionMode(0);
        this.e.setSortable(false);
        this.e.setColumnControlVisible(false);
        this.e.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && GamePadPanel.this.e.getSelectedRowCount() == 1) {
                    Point p = evt.getPoint();
                    int rowNumber = GamePadPanel.this.e.rowAtPoint(p);
                    int colnumber = GamePadPanel.this.e.columnAtPoint(p);
                    if (colnumber == 0) {
                        GamePadPanel.this.a.notifyListeners(196, rowNumber + "_" + colnumber);
                    }
                    if (colnumber == 2 || colnumber == 3) {
                        GamePadPanel.this.a.notifyListeners(193, rowNumber + "_" + colnumber);
                    }
                }
            }
        });
    }

    public void updateTableData() {
        try {
            new SwingWorker<String, Void>(){

                protected String a() {
                    if (GamePadPanel.this.h != null) {
                        GamePadPanel.this.h.clear();
                    } else {
                        GamePadPanel.this.h = new Vector();
                    }
                    GamePadPanel.this.removeTableModelListener();
                    int i = 0;
                    while (i < GamePadPanel.this.d.getFoundControllers().size()) {
                        Vector<Object> subvector = new Vector<Object>();
                        subvector.add(GamePadPanel.this.d.getFoundControllers().get(i).getIndex() + " " + GamePadPanel.this.d.getFoundControllers().get(i).getController().getName());
                        int referee = GamePadPanel.this.d.getFoundControllers().get(i).getReferee();
                        if (GamePadPanel.this.d.getFoundControllers().get(i).getReferee() == 0) {
                            subvector.add("");
                        } else {
                            subvector.add("Referee " + GamePadPanel.this.d.getFoundControllers().get(i).getReferee());
                        }
                        if (GamePadPanel.this.d.getFoundControllers().get(i).getRedscorecomp() != null) {
                            subvector.add(GamePadPanel.this.d.getFoundControllers().get(i).getRedscorecomp().getName());
                        } else {
                            subvector.add("");
                        }
                        if (GamePadPanel.this.d.getFoundControllers().get(i).getBluescorecomp() != null) {
                            subvector.add(GamePadPanel.this.d.getFoundControllers().get(i).getBluescorecomp().getName());
                        } else {
                            subvector.add("");
                        }
                        subvector.add(GamePadPanel.this.a(GamePadPanel.this.d.getFoundControllers().get(i).getStatus()));
                        GamePadPanel.this.h.add(subvector);
                        ++i;
                    }
                    return "";
                }

                @Override
                protected void done() {
                    GamePadPanel.this.e.clearSelection();
                    GamePadPanel.this.f.setDataVector(GamePadPanel.this.h, GamePadPanel.this.g);
                    GamePadPanel.this.f();
                    GamePadPanel.this.e.repaint();
                    GamePadPanel.this.setTableModelListener();
                }

                @Override
                protected /* synthetic */ Object doInBackground() throws Exception {
                    return this.a();
                }
            }.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void update(int event, String message) {
        int index2;
        if (event == 192) {
            try {
                index2 = GamePadPanel.getIntFromMessage(message, 0);
                int status = GamePadPanel.getIntFromMessage(message, 2);
                if (index2 > -1) {
                    int i = 0;
                    while (i < this.f.getRowCount()) {
                        if (i == index2) {
                            this.f.setValueAt(this.a(status), i, 4);
                        }
                        ++i;
                    }
                }
                if (this.checkInactiveStatus()) {
                    this.c();
                } else {
                    this.d();
                }
            }
            catch (Exception index2) {
                // empty catch block
            }
        }
        if (event == 194) {
            try {
                index2 = GamePadPanel.getIntFromMessage(message, 0);
                int col = GamePadPanel.getIntFromMessage(message, 2);
                String button = GamePadPanel.getStringFromMessage(message, 3);
                if (index2 > -1) {
                    int i = 0;
                    while (i < this.f.getRowCount()) {
                        if (i == index2) {
                            this.f.setValueAt(button, index2, col);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void registerPanel() {
        this.a.getListenersLast(this.c).add(this);
    }

    private void c() {
        if (this.n == null) {
            this.n = new FadeGamepadInactivePopup();
        }
        this.n.setVisible(true);
        this.n.setAlwaysOnTop(true);
    }

    private void d() {
        if (this.n != null && this.n.isVisible()) {
            this.n.setVisible(false);
        }
    }

    public boolean checkInactiveStatus() {
        boolean isinactive = false;
        int i = 0;
        while (i < this.f.getRowCount()) {
            if (this.f.getValueAt(i, 4).toString().equals(INACTIVE)) {
                isinactive = true;
                break;
            }
            ++i;
        }
        return isinactive;
    }

    public boolean checkStatusNotActiveAssigned() {
        boolean isinactive = false;
        int i = 0;
        while (i < this.f.getRowCount()) {
            if (!this.f.getValueAt(i, 4).toString().equals(ACTIVE_ASSIGNED)) {
                isinactive = true;
                break;
            }
            ++i;
        }
        return isinactive;
    }

    public static int getIntFromMessage(String message, int count) {
        int index = -1;
        String[] info = message.split("_");
        try {
            index = Integer.parseInt(info[count]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public static String getStringFromMessage(String message, int count) {
        String index = "";
        String[] info = message.split("_");
        try {
            index = info[count];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    private String a(int status) {
        String statustext = "";
        switch (status) {
            case 1: {
                statustext = NEW;
                break;
            }
            case 2: {
                statustext = ACTIVE_UNASSIGNED;
                break;
            }
            case 3: {
                statustext = ACTIVE_ASSIGNED;
                break;
            }
            case 4: {
                statustext = INACTIVE;
                break;
            }
            default: {
                statustext = "";
            }
        }
        return statustext;
    }

    private void e() {
        this.l = new JComboBox();
        this.l.addItem("");
        int i = 0;
        while (i < 4) {
            this.l.addItem("Referee " + (i + 1));
            ++i;
        }
    }

    private void f() {
        this.e.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.l));
        this.e.getColumnModel().getColumn(4).setCellRenderer(new StatusComboBoxRenderer());
    }

    private void g() {
        this.k = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                try {
                    int colnum = arg0.getColumn();
                    int rownum = arg0.getFirstRow();
                    if (colnum == 1) {
                        String referestr = (String)GamePadPanel.this.e.getValueAt(GamePadPanel.this.e.getSelectedRow(), 1);
                        int refereeid = GamePadPanel.this.a(referestr);
                        if (refereeid == -1) {
                            refereeid = 0;
                        }
                        if (!GamePadPanel.this.d.updateRefereeID(rownum, refereeid)) {
                            new FehlerFenster("Referee is already assigned to a device!");
                            GamePadPanel.this.f.setValueAt("", rownum, 1);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.setTableModelListener();
    }

    public void setTableModelListener() {
        this.e.getModel().addTableModelListener(this.k);
    }

    public void removeTableModelListener() {
        this.e.getModel().removeTableModelListener(this.k);
    }

    private int a(String item) {
        int index = -1;
        int i = 0;
        while (i < this.l.getItemCount()) {
            if (this.l.getItemAt(i).equals(item)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

