/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.FDFParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.util.XMLUtil;

public class Loader {
    private Loader() {
    }

    public static FDFDocument loadFDF(String filename) throws IOException {
        return Loader.loadFDF(new File(filename));
    }

    public static FDFDocument loadFDF(File file) throws IOException {
        try (RandomAccessReadBufferedFile readBuffer = new RandomAccessReadBufferedFile(file);){
            FDFParser parser = new FDFParser(readBuffer);
            FDFDocument fDFDocument = parser.parse();
            return fDFDocument;
        }
    }

    public static FDFDocument loadFDF(InputStream input) throws IOException {
        try (RandomAccessReadBuffer readBuffer = new RandomAccessReadBuffer(input);){
            FDFParser parser = new FDFParser(readBuffer);
            FDFDocument fDFDocument = parser.parse();
            return fDFDocument;
        }
    }

    public static FDFDocument loadXFDF(String filename) throws IOException {
        return Loader.loadXFDF(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static FDFDocument loadXFDF(File file) throws IOException {
        return Loader.loadXFDF(new BufferedInputStream(new FileInputStream(file)));
    }

    public static FDFDocument loadXFDF(InputStream input) throws IOException {
        return new FDFDocument(XMLUtil.parse(input));
    }

    public static PDDocument loadPDF(byte[] input) throws IOException {
        return Loader.loadPDF(input, "");
    }

    public static PDDocument loadPDF(byte[] input, String password) throws IOException {
        return Loader.loadPDF(input, password, null, null);
    }

    public static PDDocument loadPDF(byte[] input, String password, InputStream keyStore, String alias) throws IOException {
        return Loader.loadPDF(input, password, keyStore, alias, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(byte[] input, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        RandomAccessReadBuffer source = null;
        try {
            source = new RandomAccessReadBuffer(input);
            PDFParser parser = new PDFParser(source, password, keyStore, alias, memUsageSetting);
            return parser.parse();
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(source);
            throw ioe;
        }
    }

    public static PDDocument loadPDF(File file) throws IOException {
        return Loader.loadPDF(file, "", MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(File file, MemoryUsageSetting memUsageSetting) throws IOException {
        return Loader.loadPDF(file, "", null, null, memUsageSetting);
    }

    public static PDDocument loadPDF(File file, String password) throws IOException {
        return Loader.loadPDF(file, password, null, null, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(File file, String password, MemoryUsageSetting memUsageSetting) throws IOException {
        return Loader.loadPDF(file, password, null, null, memUsageSetting);
    }

    public static PDDocument loadPDF(File file, String password, InputStream keyStore, String alias) throws IOException {
        return Loader.loadPDF(file, password, keyStore, alias, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(File file, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        RandomAccessReadBufferedFile raFile = null;
        try {
            raFile = new RandomAccessReadBufferedFile(file);
            return Loader.loadPDF(raFile, password, keyStore, alias, memUsageSetting);
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(raFile);
            throw ioe;
        }
    }

    public static PDDocument loadPDF(RandomAccessRead raFile, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        PDFParser parser = new PDFParser(raFile, password, keyStore, alias, memUsageSetting);
        return parser.parse();
    }

    public static PDDocument loadPDF(InputStream input) throws IOException {
        return Loader.loadPDF(input, "", null, null, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(InputStream input, MemoryUsageSetting memUsageSetting) throws IOException {
        return Loader.loadPDF(input, "", null, null, memUsageSetting);
    }

    public static PDDocument loadPDF(InputStream input, String password) throws IOException {
        return Loader.loadPDF(input, password, null, null, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(InputStream input, String password, InputStream keyStore, String alias) throws IOException {
        return Loader.loadPDF(input, password, keyStore, alias, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument loadPDF(InputStream input, String password, MemoryUsageSetting memUsageSetting) throws IOException {
        return Loader.loadPDF(input, password, null, null, memUsageSetting);
    }

    public static PDDocument loadPDF(InputStream input, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        RandomAccessReadBuffer source = null;
        try {
            source = new RandomAccessReadBuffer(input);
            PDFParser parser = new PDFParser(source, password, keyStore, alias, memUsageSetting);
            return parser.parse();
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(source);
            throw ioe;
        }
    }
}

