/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard w) {
        this.wizard = w;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (evt.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (evt.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    private void nextButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        Object nextPanelDescriptor = descriptor.getNextPanelDescriptor();
        if (nextPanelDescriptor instanceof WizardPanelDescriptor.FinishIdentifier) {
            this.wizard.close(0);
        } else {
            this.wizard.setCurrentPanel(nextPanelDescriptor);
        }
    }

    private void backButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        Object backPanelDescriptor = descriptor.getBackPanelDescriptor();
        this.wizard.setCurrentPanel(backPanelDescriptor);
    }

    void resetButtonsToPanelRules() {
        WizardModel model = this.wizard.getModel();
        WizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        model.setBackButtonText(Wizard.DEFAULT_BACK_BUTTON_TEXT);
        if (descriptor.getBackPanelDescriptor() != null) {
            model.setBackButtonEnabled(Boolean.TRUE);
        } else {
            model.setBackButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() != null) {
            model.setNextButtonEnabled(Boolean.TRUE);
        } else {
            model.setNextButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() instanceof WizardPanelDescriptor.FinishIdentifier) {
            model.setNextButtonText(Wizard.DEFAULT_FINISH_BUTTON_TEXT);
            model.setNextButtonEnabled(Boolean.TRUE);
        } else {
            model.setNextButtonText(Wizard.DEFAULT_NEXT_BUTTON_TEXT);
        }
    }
}

