/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class AnimatedImageIcon
extends ImageIcon {
    private static final String CLASS_NAME = "de/schlichtherle/swing/AnimatedImageIcon".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME);
    private static final Level CALLING = new Level("CALLING", Level.FINE.intValue()){};
    private static final Level FAILED = new Level("FAILED", Level.WARNING.intValue()){};
    private static final Level RETURNED = new Level("RETURNED", Level.FINER.intValue()){};
    private int delay;
    private Image[] frames;
    private final Timer timer = new Timer(0, new Animator());
    static /* synthetic */ Class class$0;

    public AnimatedImageIcon() {
    }

    public AnimatedImageIcon(int rate, Image[] frames) {
        super(frames[0]);
        this.setRateImpl(rate);
        this.setFramesImpl(frames);
    }

    public int getRate() {
        return 1000 / this.delay;
    }

    public void setRate(int rate) {
        this.setRateImpl(rate);
    }

    private final void setRateImpl(int rate) {
        this.delay = 1000 / rate;
        this.timer.setDelay(this.delay);
    }

    public Image[] getFrames() {
        return (Image[])this.frames.clone();
    }

    public void setFrames(Image[] frames) {
        this.setFramesImpl(frames);
    }

    private final void setFramesImpl(Image[] frames) {
        this.frames = frames;
        this.setImage(frames[0]);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        logger.log(CALLING, String.valueOf(System.identityHashCode(this)) + "(c=" + System.identityHashCode(c) + ", g=" + System.identityHashCode(g) + ", x=" + x + ", y=" + y + ")");
        try {
            Image image = this.getImage();
            if (image == null) {
                return;
            }
            g.drawImage(image, x, y, null);
            this.setImageObserver(c);
            this.timer.start();
            logger.log(RETURNED, String.valueOf(System.identityHashCode(this)) + "(...)");
        }
        catch (Throwable throwable) {
            logger.log(FAILED, String.valueOf(System.identityHashCode(this)) + "(...)");
            AnimatedImageIcon.rethrow(throwable);
        }
    }

    private static void rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    private class Animator
    implements ActionListener {
        private int current;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.schlichtherle.swing.AnimatedImageIcon");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private Animator() {
        }

        public void actionPerformed(ActionEvent evt) {
            ImageObserver observer = AnimatedImageIcon.this.getImageObserver();
            this.current = (this.current + 1) % AnimatedImageIcon.this.frames.length;
            boolean ret = this.imageUpdate(observer, AnimatedImageIcon.this.frames[this.current]);
            if (!ret) {
                this.current = 0;
                ret = this.imageUpdate(observer, AnimatedImageIcon.this.frames[this.current]);
                AnimatedImageIcon.this.timer.stop();
                AnimatedImageIcon.this.setImageObserver(null);
                if (!$assertionsDisabled && ret) {
                    throw new AssertionError((Object)"The image observer should not be interested in updates anymore!");
                }
            }
        }

        private boolean imageUpdate(ImageObserver observer, Image image) {
            logger.log(CALLING, String.valueOf(System.identityHashCode(this)) + "(observer=" + System.identityHashCode(observer) + ", image=" + image + ")");
            try {
                AnimatedImageIcon.this.setImage(image);
                int width = image.getWidth(observer);
                if (!$assertionsDisabled && width != AnimatedImageIcon.this.getIconWidth()) {
                    throw new AssertionError();
                }
                int height = image.getHeight(observer);
                if (!$assertionsDisabled && height != AnimatedImageIcon.this.getIconHeight()) {
                    throw new AssertionError();
                }
                boolean ret = observer.imageUpdate(image, 16, 0, 0, width, height);
                logger.log(RETURNED, String.valueOf(System.identityHashCode(this)) + "(...)=" + ret);
                return ret;
            }
            catch (Throwable throwable) {
                logger.log(FAILED, String.valueOf(System.identityHashCode(this)) + "(...)");
                AnimatedImageIcon.rethrow(throwable);
                return false;
            }
        }
    }
}

