/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedComboBoxModel;
import de.schlichtherle.swing.EnhancedDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class ComboBoxDocumentMediator
implements Serializable {
    private final Listener listener = new Listener();
    private Document document;
    private ComboBoxModel comboBoxModel;
    private transient boolean recursion;

    public synchronized Document getDocument() {
        return this.document;
    }

    public synchronized void setDocument(Document newDoc) {
        Document oldDoc = this.getDocument();
        if (newDoc == oldDoc) {
            return;
        }
        if (oldDoc != null) {
            oldDoc.removeDocumentListener(this.listener);
            if (oldDoc instanceof EnhancedDocument) {
                ((EnhancedDocument)oldDoc).removePropertyChangeListener("editable", this.listener);
            }
        }
        this.document = newDoc;
        if (newDoc != null) {
            newDoc.addDocumentListener(this.listener);
            this.documentUpdated();
            if (newDoc instanceof EnhancedDocument) {
                ((EnhancedDocument)newDoc).addPropertyChangeListener("editable", this.listener);
                this.documentEditableChanged();
            }
        }
    }

    public synchronized ComboBoxModel getComboBoxModel() {
        return this.comboBoxModel;
    }

    public synchronized void setComboBoxModel(ComboBoxModel newCBM) {
        ComboBoxModel oldCBM = this.getComboBoxModel();
        if (newCBM == oldCBM) {
            return;
        }
        if (oldCBM != null) {
            oldCBM.removeListDataListener(this.listener);
            if (oldCBM instanceof EnhancedComboBoxModel) {
                ((EnhancedComboBoxModel)oldCBM).removePropertyChangeListener("enabled", this.listener);
            }
        }
        this.comboBoxModel = newCBM;
        if (newCBM != null) {
            newCBM.addListDataListener(this.listener);
            this.comboBoxModelSelectionChanged();
            if (newCBM instanceof EnhancedComboBoxModel) {
                ((EnhancedComboBoxModel)newCBM).addPropertyChangeListener("enabled", this.listener);
                this.comboBoxModelEnabledChanged();
            }
        }
    }

    private synchronized void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            ComboBoxModel cbm = this.getComboBoxModel();
            if (cbm == null) {
                return;
            }
            Document doc = this.getDocument();
            String text = ComboBoxDocumentMediator.getText(doc);
            cbm.setSelectedItem(text);
        }
        finally {
            this.unlock();
        }
    }

    private synchronized void documentEditableChanged() {
        if (this.lock()) {
            return;
        }
        try {
            ComboBoxModel cbm = this.getComboBoxModel();
            if (cbm instanceof EnhancedComboBoxModel) {
                EnhancedComboBoxModel ecbm = (EnhancedComboBoxModel)cbm;
                boolean e = ((EnhancedDocument)this.getDocument()).isEditable();
                ecbm.setEditable(e);
                ecbm.setEnabled(e);
            }
        }
        finally {
            this.unlock();
        }
    }

    private synchronized void comboBoxModelSelectionChanged() {
        if (this.lock()) {
            return;
        }
        try {
            Document doc = this.getDocument();
            if (doc == null) {
                return;
            }
            ComboBoxModel cbm = this.getComboBoxModel();
            Object item = cbm.getSelectedItem();
            ComboBoxDocumentMediator.setText(doc, item != null ? item.toString() : null);
        }
        finally {
            this.unlock();
        }
    }

    private synchronized void comboBoxModelEnabledChanged() {
        if (this.lock()) {
            return;
        }
        try {
            Document doc = this.getDocument();
            if (doc instanceof EnhancedDocument) {
                ((EnhancedDocument)doc).setEditable(((EnhancedComboBoxModel)this.getComboBoxModel()).isEnabled());
            }
        }
        finally {
            this.unlock();
        }
    }

    private final boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private final void unlock() {
        this.recursion = false;
    }

    public static final String getText(Document doc) {
        return EnhancedDocument.getText(doc);
    }

    public static final void setText(Document doc, String str) {
        EnhancedDocument.setText(doc, str);
    }

    private final class Listener
    implements DocumentListener,
    ListDataListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ComboBoxDocumentMediator.this.documentUpdated();
        }

        public void removeUpdate(DocumentEvent e) {
            ComboBoxDocumentMediator.this.documentUpdated();
        }

        public void changedUpdate(DocumentEvent e) {
            ComboBoxDocumentMediator.this.documentUpdated();
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() < 0 && e.getIndex1() < 0) {
                ComboBoxDocumentMediator.this.comboBoxModelSelectionChanged();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if ("enabled".equals(property)) {
                ComboBoxDocumentMediator.this.comboBoxModelEnabledChanged();
            } else if ("editable".equals(property)) {
                ComboBoxDocumentMediator.this.documentEditableChanged();
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + property));
            }
        }
    }
}

