/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedComboBoxModel;
import de.schlichtherle.swing.EnhancedDocument;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class EnhancedComboBox
extends JComboBox {
    public static final String PROPERTY_PUSHING_PROPERTY_CHANGES = "pushingPropertyChanges";
    private static final long serialVersionUID = 1L;
    private final PropertyChangeListener controller = new Controller();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.schlichtherle.swing.EnhancedComboBox");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public EnhancedComboBox(ComboBoxModel model) {
        this.changeModel(super.getModel(), model);
    }

    public EnhancedComboBox(Object[] items) {
        this.changeModel(super.getModel(), new EnhancedComboBoxModel(items));
    }

    public EnhancedComboBox(Vector items) {
        this.changeModel(super.getModel(), new EnhancedComboBoxModel(items));
    }

    public EnhancedComboBox() {
        this.changeModel(super.getModel(), new EnhancedComboBoxModel());
    }

    public void setModel(ComboBoxModel newModel) {
        this.changeModel(this.getModel(), newModel);
    }

    public void setEditor(ComboBoxEditor newEditor) {
        this.changeEditor(this.getEditor(), newEditor);
    }

    public Document getDocument() {
        if (!this.isEditable()) {
            throw new IllegalStateException();
        }
        JTextComponent text = this.getTextComponent();
        return text != null ? text.getDocument() : null;
    }

    public void setDocument(Document newDoc) {
        if (!this.isEditable()) {
            throw new IllegalStateException();
        }
        this.changeDocument(this.getDocument(), newDoc);
    }

    public void setEnabled(boolean newEnabled) {
        this.changeEnabled(this.isEnabled(), newEnabled);
    }

    public void setEditable(boolean newEditable) {
        this.changeEditable(this.isEditable(), newEditable);
    }

    private void changeModel(ComboBoxModel oldModel, ComboBoxModel newModel) {
        if (newModel == oldModel) {
            return;
        }
        if (oldModel instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)oldModel).removePropertyChangeListener(this.controller);
        }
        super.setModel(newModel);
        if (newModel instanceof EnhancedComboBoxModel) {
            EnhancedComboBoxModel enhNewModel = (EnhancedComboBoxModel)newModel;
            enhNewModel.addPropertyChangeListener(this.controller);
            boolean editable = enhNewModel.isEditable();
            this.changeEditable(super.isEditable(), editable);
            boolean enabled = enhNewModel.isEnabled();
            this.changeEnabled(super.isEnabled(), enabled);
        }
    }

    private void changeEditor(ComboBoxEditor oldCBE, ComboBoxEditor newCBE) {
        Component component;
        Component component2;
        if (newCBE == oldCBE) {
            return;
        }
        JTextComponent oldText = null;
        if (oldCBE != null && (component2 = oldCBE.getEditorComponent()) instanceof JTextComponent) {
            oldText = (JTextComponent)component2;
        }
        super.setEditor(newCBE);
        JTextComponent newText = null;
        if (newCBE != null && (component = newCBE.getEditorComponent()) instanceof JTextComponent) {
            newText = (JTextComponent)component;
        }
        this.changeText(oldText, newText);
    }

    private void changeText(JTextComponent oldTC, JTextComponent newTC) {
        if (newTC == oldTC) {
            return;
        }
        Document oldDocument = null;
        if (oldTC != null) {
            oldTC.removePropertyChangeListener("document", this.controller);
            oldDocument = oldTC.getDocument();
        }
        Document newDocument = null;
        if (newTC != null) {
            newTC.addPropertyChangeListener("document", this.controller);
            newDocument = newTC.getDocument();
        }
        this.changeDocument(oldDocument, newDocument);
    }

    private void changeDocument(Document oldDoc, Document newDoc) {
        JTextComponent text;
        if (newDoc == oldDoc) {
            return;
        }
        if (oldDoc instanceof EnhancedDocument) {
            EnhancedDocument enhOldDoc = (EnhancedDocument)oldDoc;
            enhOldDoc.removePropertyChangeListener("editable", this.controller);
        }
        if ((text = this.getTextComponent()) != null) {
            text.setDocument(newDoc);
        }
        if (newDoc instanceof EnhancedDocument) {
            EnhancedDocument enhNewDoc = (EnhancedDocument)newDoc;
            enhNewDoc.addPropertyChangeListener("editable", this.controller);
            boolean editable = enhNewDoc.isEditable();
            this.changeEnabled(super.isEnabled(), editable);
        }
    }

    private void changeEditable(boolean oldEditable, boolean newEditable) {
        JTextComponent text;
        if (newEditable == oldEditable) {
            return;
        }
        super.setEditable(newEditable);
        ComboBoxModel model = super.getModel();
        if (model instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)model).setEditable(newEditable);
        }
        if ((text = this.getTextComponent()) != null) {
            Document oldDoc = text.getDocument();
            if (oldDoc instanceof EnhancedDocument) {
                ((EnhancedDocument)oldDoc).setEditable(newEditable);
            } else if (!oldEditable) {
                if (!$assertionsDisabled && !newEditable) {
                    throw new AssertionError();
                }
                EnhancedDocument newDoc = new EnhancedDocument();
                if (!$assertionsDisabled && !newDoc.isEditable()) {
                    throw new AssertionError();
                }
                this.changeDocument(oldDoc, newDoc);
            }
        }
    }

    private void changeEnabled(boolean oldEnabled, boolean newEnabled) {
        if (newEnabled == oldEnabled) {
            return;
        }
        super.setEnabled(newEnabled);
        ComboBoxModel model = super.getModel();
        if (model instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)model).setEnabled(newEnabled);
        }
    }

    private JTextComponent getTextComponent() {
        Component comp;
        ComboBoxEditor editor = super.getEditor();
        if (editor != null && (comp = editor.getEditorComponent()) instanceof JTextComponent) {
            return (JTextComponent)comp;
        }
        return null;
    }

    private final class Controller
    implements PropertyChangeListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.schlichtherle.swing.EnhancedComboBox");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private Controller() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object source = e.getSource();
            String property = e.getPropertyName();
            JTextComponent text = EnhancedComboBox.this.getTextComponent();
            if (text != null && source == text.getDocument()) {
                if (!$assertionsDisabled && !"editable".equals(property)) {
                    throw new AssertionError();
                }
                EnhancedComboBox.this.changeEnabled(Boolean.TRUE.equals(e.getOldValue()), Boolean.TRUE.equals(e.getNewValue()));
            } else if (source == text) {
                if (!$assertionsDisabled && !"document".equals(property)) {
                    throw new AssertionError();
                }
                EnhancedComboBox.this.changeDocument((Document)e.getOldValue(), (Document)e.getNewValue());
            } else {
                if (!$assertionsDisabled && source != EnhancedComboBox.this.getModel()) {
                    throw new AssertionError();
                }
                if ("editable".equals(property)) {
                    EnhancedComboBox.this.changeEditable(Boolean.TRUE.equals(e.getOldValue()), Boolean.TRUE.equals(e.getNewValue()));
                } else if ("enabled".equals(property)) {
                    EnhancedComboBox.this.changeEnabled(Boolean.TRUE.equals(e.getOldValue()), Boolean.TRUE.equals(e.getNewValue()));
                }
            }
        }
    }
}

