/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;

public class EnhancedComboBoxModel
extends DefaultComboBoxModel
implements MutableComboBoxModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_EDITABLE = "editable";
    private boolean enabled = true;
    private boolean editable;
    protected PropertyChangeSupport changeSupport;

    public EnhancedComboBoxModel() {
    }

    public EnhancedComboBoxModel(Object[] items) {
        super(items);
    }

    public EnhancedComboBoxModel(Vector v) {
        super(v);
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean newEnabled) {
        boolean oldEnabled = this.isEnabled();
        if (newEnabled == oldEnabled) {
            return;
        }
        this.enabled = newEnabled;
        this.firePropertyChange(PROPERTY_ENABLED, oldEnabled, newEnabled);
    }

    public synchronized boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean newEditable) {
        boolean oldEditable = this.isEditable();
        if (newEditable == oldEditable) {
            return;
        }
        this.editable = newEditable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldEditable, newEditable);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

