/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedRootPane;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class EnhancedFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String[] suffixes = new String[]{".png", ".jpeg", ".jpg", ".gif"};

    public EnhancedFrame() throws HeadlessException {
        this.initComponents();
    }

    public EnhancedFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initComponents();
    }

    public EnhancedFrame(String title) throws HeadlessException {
        super(title);
        this.initComponents();
    }

    public EnhancedFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initComponents();
    }

    private void initComponents() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = null;
        int i = 0;
        int l = suffixes.length;
        while (i < l && url == null) {
            String suffix = suffixes[i];
            url = cl.getResource("images/applIcon" + suffix);
            if (url == null) {
                url = cl.getResource("resources/applIcon" + suffix);
            }
            ++i;
        }
        if (url != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(url));
        }
    }

    protected JRootPane createRootPane() {
        return new EnhancedRootPane();
    }

    public void setDefaultButton(JButton button) {
        JRootPane rp = this.getRootPane();
        if (rp instanceof EnhancedRootPane) {
            ((EnhancedRootPane)rp).setRestorableDefaultButton(button);
        } else {
            rp.setDefaultButton(button);
        }
    }

    public JButton getDefaultButton() {
        return this.getRootPane().getDefaultButton();
    }
}

