/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.io.Serializable;

public class MnemonicText
implements Serializable {
    private static final String HTML_TAG = "<html>";
    private static final int HTML_TAG_LENGTH = "<html>".length();
    private final String text;
    private final int mnemonicIndex;
    private final char mnemonic;
    private final boolean isHtmlText;

    public MnemonicText(String text) {
        int mnemonicIndex = -1;
        char mnemonic = '\u0000';
        StringBuffer buf = new StringBuffer(text.length());
        int l = text.length();
        int i = 0;
        while (i < l) {
            char c = text.charAt(i);
            if (c == '&') {
                if (++i >= l) break;
                c = text.charAt(i);
                if (c != '&' && mnemonicIndex == -1) {
                    mnemonic = c;
                    mnemonicIndex = buf.length();
                }
            }
            buf.append(c);
            ++i;
        }
        this.text = buf.length() != l ? buf.toString() : text;
        this.mnemonicIndex = mnemonicIndex;
        this.mnemonic = mnemonic;
        String trim = text.trim();
        this.isHtmlText = trim.substring(0, Math.min(HTML_TAG_LENGTH, trim.length())).equalsIgnoreCase(HTML_TAG);
    }

    public String getText() {
        return this.text;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public final boolean isHtmlText() {
        return this.isHtmlText;
    }
}

