/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.action.core.CommonSimpleButtonAction;
import bibliothek.gui.dock.common.action.panel.DialogWindow;
import bibliothek.gui.dock.common.action.panel.MenuWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindowListener;
import bibliothek.gui.dock.common.intern.action.CDecorateableAction;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CPanelPopup
extends CDecorateableAction<PanelPopup> {
    public static final ActionType<PanelPopup> PANEL_POPUP = new ActionType("panel popup");
    private MenuBehavior menu = MenuBehavior.UNDECORATED_DIALOG;
    private ButtonBehavior button = ButtonBehavior.OPEN_ON_CLICK;
    private JComponent content;
    private PanelPopupWindow window;
    private boolean closeOnFocusLost = true;
    private PanelPopupWindowListener listener = new PanelPopupWindowListener(){

        @Override
        public void closed(PanelPopupWindow window) {
            window.removeListener(CPanelPopup.this.listener);
            window = null;
        }
    };

    public CPanelPopup() {
        super(null);
        this.init(new PanelPopup());
    }

    public void setContent(JComponent content) {
        this.content = content;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setMenuBehavior(MenuBehavior menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu must not be null");
        }
        this.menu = menu;
    }

    public MenuBehavior getMenuBehavior() {
        return this.menu;
    }

    public void setButtonBehavior(ButtonBehavior button) {
        if (button == null) {
            throw new IllegalArgumentException("button must not be null");
        }
        this.button = button;
    }

    public ButtonBehavior getButtonBehavior() {
        return this.button;
    }

    public void setCloseOnFocusLost(boolean closeOnFocusLost) {
        this.closeOnFocusLost = closeOnFocusLost;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost;
    }

    public void openPopup(PanelPopupWindow window) {
        if (!window.isOpen()) {
            throw new IllegalArgumentException("window is not open");
        }
        this.closePopup();
        this.window = window;
        this.window.addListener(this.listener);
    }

    public void closePopup() {
        if (this.window != null) {
            this.window.close();
        }
    }

    public boolean isOpen() {
        return this.window != null && this.window.isOpen();
    }

    protected void onMousePressed(Dockable dockable, JComponent item, DockTitle.Orientation orientation) {
        if (this.getButtonBehavior() == ButtonBehavior.OPEN_ON_PRESS) {
            this.openDialog(dockable, item, orientation);
        }
    }

    protected void onMouseReleased(Dockable dockable, JComponent item, DockTitle.Orientation orientation) {
        if (this.getButtonBehavior() == ButtonBehavior.OPEN_ON_CLICK) {
            this.openDialog(dockable, item, orientation);
        }
    }

    protected void onTrigger(Dockable dockable, JComponent item, DockTitle.Orientation orientation) {
        this.openDialog(dockable, item, orientation);
    }

    protected void openDialog(Dockable dockable, final JComponent item, DockTitle.Orientation orientation) {
        if (this.isOpen() || this.content == null) {
            return;
        }
        final Point location = new Point();
        if (orientation.isHorizontal()) {
            location.y = item.getHeight();
        } else {
            location.x = item.getWidth();
        }
        SwingUtilities.convertPointToScreen(location, item);
        this.executeOneDockableHasFocus(dockable, new Runnable(){

            @Override
            public void run() {
                DialogWindow window = CPanelPopup.this.createDialogWindow(item);
                window.setUndecorated(true);
                window.setContent(CPanelPopup.this.getContent());
                window.open(location.x, location.y);
                CPanelPopup.this.openPopup(window);
            }
        });
    }

    protected void onMenuItemTrigger(final Dockable dockable) {
        if (this.content == null) {
            return;
        }
        this.closePopup();
        this.executeOneDockableHasFocus(dockable, new Runnable(){

            @Override
            public void run() {
                DialogWindow window = CPanelPopup.this.createDialogWindow(dockable.getComponent());
                window.setUndecorated(CPanelPopup.this.getMenuBehavior() == MenuBehavior.UNDECORATED_DIALOG);
                window.setContent(CPanelPopup.this.getContent());
                window.open(dockable.getComponent());
                CPanelPopup.this.openPopup(window);
            }
        });
    }

    protected DialogWindow createDialogWindow(Component owner) {
        return new DialogWindow(owner, this);
    }

    protected void onMenuTrigger(JPopupMenu menu) {
        if (this.content == null) {
            return;
        }
        menu.add(this.content);
        MenuWindow window = this.createMenuWindow(menu);
        this.openPopup(window);
    }

    protected MenuWindow createMenuWindow(JPopupMenu menu) {
        return new MenuWindow(menu);
    }

    protected void executeOneDockableHasFocus(Dockable dockable, Runnable run) {
        DockController controller = dockable.getController();
        if (controller != null) {
            controller.getFocusController().onFocusRequestCompletion(run);
        } else {
            run.run();
        }
    }

    public class PanelPopup
    extends CommonSimpleButtonAction {
        public PanelPopup() {
            super(CPanelPopup.this);
        }

        @Override
        public <V> V createView(ViewTarget<V> target, ActionViewConverter converter, Dockable dockable) {
            return converter.createView(PANEL_POPUP, this, target, dockable);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            return false;
        }

        @Override
        public CPanelPopup getAction() {
            return CPanelPopup.this;
        }

        public void onMousePressed(Dockable dockable, JComponent item, DockTitle.Orientation orientation) {
            CPanelPopup.this.onMousePressed(dockable, item, orientation);
        }

        public void onMouseReleased(Dockable dockable, JComponent item, DockTitle.Orientation orientation) {
            CPanelPopup.this.onMouseReleased(dockable, item, orientation);
        }

        public void onTrigger(Dockable dockable, JComponent item, DockTitle.Orientation orientation) {
            CPanelPopup.this.onTrigger(dockable, item, orientation);
        }

        public void onMenuItemTrigger(Dockable dockable) {
            CPanelPopup.this.onMenuItemTrigger(dockable);
        }

        public void onMenuTrigger(JPopupMenu menu) {
            CPanelPopup.this.onMenuTrigger(menu);
        }
    }

    public static enum ButtonBehavior {
        OPEN_ON_PRESS,
        OPEN_ON_CLICK;

    }

    public static enum MenuBehavior {
        HIDE,
        SUBMENU,
        UNDECORATED_DIALOG,
        DECORATED_DIALOG;

    }
}

