/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.event.CDockableLocationEvent;
import bibliothek.gui.dock.common.event.CDockableLocationListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.dockable.DockableStateEvent;
import bibliothek.gui.dock.dockable.DockableStateListener;
import java.awt.EventQueue;

public class CDockableLocationListenerManager {
    private CDockable dockable;
    private CDockableLocationListener listener;
    private CLocation location;
    private boolean showing;
    private boolean delayed = false;
    private DockableStateListener dockableListener = new DockableStateListener(){

        @Override
        public void changed(DockableStateEvent event) {
            CDockableLocationListenerManager.this.check();
        }
    };

    public CDockableLocationListenerManager(CDockable dockable) {
        this.dockable = dockable;
    }

    public void setListener(CDockableLocationListener listener) {
        if (this.listener == null) {
            this.dockable.intern().removeDockableStateListener(this.dockableListener);
        }
        this.listener = null;
        if (listener != null) {
            this.check();
            this.listener = listener;
            this.dockable.intern().addDockableStateListener(this.dockableListener);
        }
    }

    private void check() {
        if (!this.delayed) {
            this.delayed = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CDockableLocationListenerManager.this.delayed = false;
                    CDockableLocationListenerManager.this.checkNow();
                }
            });
        }
    }

    private void checkNow() {
        boolean newShowing = this.dockable.isShowing();
        CLocation newLocation = this.dockable.getBaseLocation();
        boolean oldShowing = this.showing;
        CLocation oldLocation = this.location;
        this.showing = newShowing;
        this.location = newLocation;
        boolean locationEvent = false;
        if (!(newLocation == null && oldLocation == null || newLocation != null && newLocation.equals(oldLocation))) {
            locationEvent = true;
        }
        if ((locationEvent || newShowing != oldShowing) && this.listener != null) {
            CDockableLocationEvent event = new CDockableLocationEvent(this.dockable, oldShowing, newShowing, oldLocation, newLocation);
            this.listener.changed(event);
        }
    }
}

