/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.intern.color.MinimizedButtonColorTransmitter;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;

public class BasicButtonTitleTransmitter
extends MinimizedButtonColorTransmitter {
    private static final String[] KEYS = new String[]{"title.flap.active", "title.flap.active.text", "title.flap.inactive", "title.flap.inactive.text", "title.flap.selected", "title.flap.selected.text"};

    public BasicButtonTitleTransmitter(ColorManager manager) {
        super(manager, KEYS);
    }

    @Override
    protected Color convert(Color source, String key) {
        if (this.isFocused(key)) {
            return this.convertFocused(source, key);
        }
        if (this.isSelected(key)) {
            return this.convertSelected(source, key);
        }
        if (key.contains("text")) {
            return Colors.diffMirror(source, 0.9);
        }
        return source;
    }

    @Override
    protected Color convertFocused(Color source, String key) {
        if (key.contains("text")) {
            return Colors.diffMirror(source, 1.0);
        }
        return source;
    }

    @Override
    protected Color convertSelected(Color source, String key) {
        if (key.contains("text")) {
            return Colors.diffMirror(source, 1.0);
        }
        return source;
    }

    @Override
    protected boolean isFocused(String id) {
        return id.contains("active") && !id.contains("inactive");
    }

    @Override
    protected boolean isForeground(String id) {
        return id.contains("text");
    }

    @Override
    protected boolean isSelected(String id) {
        return id.contains("selected");
    }
}

