/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CommonDockStationLayout {
    private String id;
    private boolean root;
    private String factoryId;
    private DockLayoutInfo layout = new DockLayoutInfo();

    public CommonDockStationLayout(String id, boolean root, String factoryId, DockLayout<?> layout) {
        if (factoryId == null) {
            throw new IllegalArgumentException("factoryId must not be null");
        }
        this.id = id;
        this.root = root;
        this.factoryId = factoryId;
        if (layout != null) {
            this.layout.setData(layout);
        }
    }

    public CommonDockStationLayout(String id, boolean root, String factoryId, byte[] layout) {
        if (factoryId == null) {
            throw new IllegalArgumentException("factoryId must not be null");
        }
        this.id = id;
        this.root = root;
        this.factoryId = factoryId;
        if (layout != null) {
            this.layout.setData(layout);
        }
    }

    public CommonDockStationLayout(String id, boolean root, String factoryId, XElement layout) {
        if (factoryId == null) {
            throw new IllegalArgumentException("factoryId must not be null");
        }
        this.id = id;
        this.root = root;
        this.factoryId = factoryId;
        if (layout != null) {
            this.layout.setData(layout);
        }
    }

    public void updateLayout(DockFactory<?, ?, Object> factory, PlaceholderStrategy placeholders) {
        try {
            Object data = null;
            switch (this.layout.getKind()) {
                case BYTE: {
                    data = factory.read(new DataInputStream(new ByteArrayInputStream(this.layout.getDataByte())), placeholders);
                    break;
                }
                case XML: {
                    data = factory.read(this.layout.getDataXML(), placeholders);
                }
            }
            if (data != null) {
                this.layout.setData(new DockLayout<Object>(factory.getID(), data));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public byte[] getLayoutBytes() {
        return this.layout.getDataByte();
    }

    public XElement getLayoutXML() {
        return this.layout.getDataXML();
    }

    public DockLayout<?> getLayout() {
        return this.layout.getDataLayout();
    }
}

