/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.EnableableItem;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.List;

public class CDisablingStrategy
implements DisablingStrategy {
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void enabledChanged(CDockable dockable) {
            CommonDockable item = dockable.intern();
            for (DisablingStrategyListener listener : CDisablingStrategy.this.listeners.toArray(new DisablingStrategyListener[CDisablingStrategy.this.listeners.size()])) {
                listener.changed(item);
            }
        }
    };
    private List<DisablingStrategyListener> listeners = new ArrayList<DisablingStrategyListener>();

    public CDisablingStrategy(CControl control) {
        control.addPropertyListener(this.propertyListener);
    }

    @Override
    public void addDisablingStrategyListener(DisablingStrategyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDisablingStrategyListener(DisablingStrategyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isDisabled(DockElement item) {
        Dockable dockable = item.asDockable();
        if (dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.SELF);
        }
        return false;
    }

    @Override
    public boolean isDisabled(Dockable dockable, DockAction item) {
        if (dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.ACTIONS);
        }
        return false;
    }

    @Override
    public boolean isDisabled(Dockable dockable, DockTitle item) {
        if (dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.TITLES);
        }
        return false;
    }

    @Override
    public boolean isTabDisabled(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.TABS);
        }
        return false;
    }
}

