/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.HashSet;

public class WorkingAreaAcceptance
implements DockAcceptance {
    private CControlAccess control;

    public WorkingAreaAcceptance(CControlAccess control) {
        this.control = control;
    }

    @Override
    public boolean accept(DockStation parent, Dockable child, Dockable next) {
        if (this.accept(parent, next)) {
            return this.getWorkingArea(child, true) == this.getWorkingArea(next, true);
        }
        return false;
    }

    @Override
    public boolean accept(DockStation parent, Dockable child) {
        CGroupMovement action;
        CLocationModeManager manager = this.control.getLocationManager();
        if (manager.isOnTransaction() && ((action = manager.getCurrentAction()) == null || action.forceAccept(parent, child))) {
            return true;
        }
        ExtendedMode extendedMode = manager.childsExtendedMode(parent);
        if (extendedMode == null && (extendedMode = manager.getMode(child)) == null) {
            return true;
        }
        CLocationMode mode = (CLocationMode)manager.getMode(extendedMode.getModeIdentifier());
        if (mode == null) {
            return true;
        }
        if (!mode.respectWorkingAreas(parent)) {
            return true;
        }
        CStation<?> area = this.searchArea(parent);
        return this.match(area, child);
    }

    private CStation<?> searchArea(DockElement element) {
        DockStation station = element.asDockStation();
        Dockable dockable = element.asDockable();
        while (dockable != null || station != null) {
            CStation cstation;
            if (station instanceof CommonDockStation && (cstation = ((CommonDockStation)station).getStation()).isWorkingArea()) {
                return cstation;
            }
            dockable = station == null ? null : station.asDockable();
            station = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    private boolean match(CStation<?> area, Dockable dockable) {
        DockStation station;
        if (dockable instanceof CommonDockable) {
            CStation<?> expectedWorkingArea = this.getWorkingArea(dockable, false);
            CDockable self = ((CommonDockable)dockable).getDockable();
            if (expectedWorkingArea != area && expectedWorkingArea != self) {
                return false;
            }
        }
        if ((station = dockable.asDockStation()) != null) {
            CStation<?> cstation;
            if (dockable instanceof CommonDockable && (cstation = ((CommonDockable)dockable).getStation()) != null && cstation.isWorkingArea()) {
                return true;
            }
            return this.match(area, station);
        }
        return true;
    }

    private CStation<?> getWorkingArea(Dockable dockable, boolean excludeSelf) {
        CStation<?> station;
        final HashSet workingAreas = new HashSet();
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            @Override
            public void handleDockable(Dockable dockable) {
                CDockable fdockable;
                CStation<?> workingArea;
                if (dockable instanceof CommonDockable && (workingArea = (fdockable = ((CommonDockable)dockable).getDockable()).getWorkingArea()) != null) {
                    workingAreas.add(workingArea);
                }
            }
        });
        if (dockable instanceof CommonDockable && (station = ((CommonDockable)dockable).getDockable().asStation()) != null && station.isWorkingArea()) {
            workingAreas.remove(station);
        }
        if (workingAreas.size() == 1) {
            return (CStation)workingAreas.iterator().next();
        }
        return null;
    }

    private boolean match(CStation<?> area, DockStation station) {
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            boolean result = this.match(area, station.getDockable(i));
            if (result) continue;
            return false;
        }
        return true;
    }
}

