/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.preference;

import bibliothek.extension.gui.dock.preference.preferences.choice.DefaultChoice;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.common.theme.ThemeMap;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeMetaListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ThemeChoice
extends DefaultChoice<ThemeFactory> {
    private List<FactoryWrapper> wrappers = new ArrayList<FactoryWrapper>();

    public ThemeChoice(ThemeMap themes, DockController controller) {
        super(controller);
        this.setNullEntryAllowed(false);
        int n = themes.size();
        for (int i = 0; i < n; ++i) {
            FactoryWrapper wrapper = new FactoryWrapper(themes.getKey(i), themes.getFactory(i));
            this.wrappers.add(wrapper);
            wrapper.install();
        }
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        for (FactoryWrapper wrapper : this.wrappers) {
            wrapper.setController(controller);
        }
    }

    @Override
    public void remove(int index) {
        String id = this.getId(index);
        super.remove(index);
        Iterator<FactoryWrapper> iterator = this.wrappers.iterator();
        while (iterator.hasNext()) {
            FactoryWrapper wrapper = iterator.next();
            if (!wrapper.key.equals(id)) continue;
            wrapper.setController(null);
            iterator.remove();
        }
    }

    private class FactoryWrapper
    implements ThemeMetaListener {
        private String key;
        private ThemeFactory factory;
        private ThemeMeta meta;
        private DefaultChoice.Entry<ThemeFactory> entry;

        public FactoryWrapper(String key, ThemeFactory factory) {
            this.key = key;
            this.factory = factory;
        }

        public void install() {
            this.entry = ThemeChoice.this.add(this.key, "", this.factory);
        }

        public void setController(DockController controller) {
            if (controller == null) {
                this.entry.setEntryText("");
                if (this.meta != null) {
                    this.meta.removeListener(this);
                    this.meta = null;
                }
            } else {
                if (this.meta != null) {
                    this.meta.removeListener(this);
                    this.meta = null;
                }
                this.meta = this.factory.createMeta(controller);
                this.meta.addListener(this);
                this.entry.setEntryText(this.meta.getName());
            }
        }

        @Override
        public void nameChanged(ThemeMeta meta) {
            this.entry.setEntryText(meta.getName());
        }

        @Override
        public void authorsChanged(ThemeMeta meta) {
        }

        @Override
        public void descriptionChanged(ThemeMeta meta) {
        }

        @Override
        public void webpagesChanged(ThemeMeta meta) {
        }
    }
}

