/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.facile.menu.FreeMenuPiece;
import bibliothek.gui.dock.facile.menu.FrontendSettingsDeleteList;
import bibliothek.gui.dock.facile.menu.FrontendSettingsLoadList;
import bibliothek.gui.dock.facile.menu.MenuPieceText;
import bibliothek.gui.dock.facile.menu.NodeMenuPiece;
import bibliothek.gui.dock.facile.menu.RootMenuPiece;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.SeparatingMenuPiece;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class FrontendSettingsMenuPiece
extends NodeMenuPiece {
    private FrontendSettingsDeleteList delete;
    private FrontendSettingsLoadList load;
    private DockFrontend frontend;
    private MenuPieceText textSave;
    private MenuPieceText textSaveAs;
    private MenuPieceText textLoad;
    private MenuPieceText textDelete;

    public FrontendSettingsMenuPiece(DockFrontend frontend, boolean loadAsSubmenu) {
        this.delete = new FrontendSettingsDeleteList(frontend);
        this.load = new FrontendSettingsLoadList(frontend);
        this.frontend = frontend;
        FreeMenuPiece menu = new FreeMenuPiece();
        final JMenuItem save = new JMenuItem();
        this.textSave = new MenuPieceText("FrontendSettingsMenuPiece.save", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                save.setText(newValue);
            }
        };
        final JMenuItem saveAs = new JMenuItem();
        this.textSaveAs = new MenuPieceText("FrontendSettingsMenuPiece.saveAs", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                saveAs.setText(newValue);
            }
        };
        menu.add(save);
        menu.add(saveAs);
        if (loadAsSubmenu) {
            final RootMenuPiece rootLoad = new RootMenuPiece(null, true, new MenuPiece[0]);
            this.textLoad = new MenuPieceText("FrontendSettingsMenuPiece.load", this){

                @Override
                protected void changed(String oldValue, String newValue) {
                    rootLoad.getMenu().setText(newValue);
                }
            };
            menu.add(rootLoad.getMenu());
            rootLoad.add(this.load);
        }
        final RootMenuPiece rootDelete = new RootMenuPiece(null, true, new MenuPiece[0]);
        this.textDelete = new MenuPieceText("FrontendSettingsMenuPiece.delete", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                rootDelete.getMenu().setText(newValue);
            }
        };
        rootDelete.add(this.delete);
        menu.add(rootDelete.getMenu());
        this.add(menu);
        if (!loadAsSubmenu) {
            this.add(new SeparatingMenuPiece(this.load, true, false, false));
        }
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrontendSettingsMenuPiece.this.save((Component)e.getSource());
            }
        });
        saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrontendSettingsMenuPiece.this.saveAs((Component)e.getSource());
            }
        });
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend frontend) {
        this.frontend = frontend;
        this.load.setFrontend(frontend);
        this.delete.setFrontend(frontend);
        if (this.isBound()) {
            if (frontend == null) {
                this.link(null);
            } else {
                this.link(frontend.getController());
            }
        }
    }

    @Override
    public void bind() {
        super.bind();
        if (this.frontend != null) {
            this.link(this.frontend.getController());
        }
    }

    @Override
    public void unbind() {
        super.unbind();
        this.link(null);
    }

    private void link(DockController controller) {
        this.textDelete.setController(controller);
        this.textSave.setController(controller);
        this.textSaveAs.setController(controller);
        if (this.textLoad != null) {
            this.textLoad.setController(controller);
        }
    }

    public void save(Component owner) {
        if (this.frontend != null) {
            if (this.frontend.getCurrentSetting() == null) {
                this.saveAs(owner);
            } else {
                this.frontend.save();
            }
        }
    }

    public void saveAs(Component owner) {
        if (this.frontend != null) {
            MenuPieceText text = new MenuPieceText("FrontendSettingsMenuPiece.saveAsInput", this){

                @Override
                protected void changed(String oldValue, String newValue) {
                }
            };
            if (this.frontend != null) {
                text.setController(this.frontend.getController());
            }
            String dialogText = (String)text.value();
            text.setController(null);
            String input = JOptionPane.showInputDialog(owner, (Object)dialogText);
            if (input != null) {
                Set<String> settings = this.frontend.getSettings();
                if (settings.contains(input)) {
                    int count = 1;
                    while (settings.contains(input + " (" + count + ")")) {
                        ++count;
                    }
                    input = input + " (" + count + ")";
                }
                this.frontend.save(input);
            }
        }
    }
}

