/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.extension.gui.dock.DockingFramesPreference;
import bibliothek.extension.gui.dock.preference.PreferenceTreeDialog;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.facile.menu.MenuPieceText;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class PreferenceMenuPiece
extends BaseMenuPiece {
    private DockController controller;
    private PreferenceTreeModel model;
    private MenuPieceText text;
    private AbstractAction action = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferenceTreeModel model = PreferenceMenuPiece.this.getModel();
            PreferenceTreeDialog dialog = new PreferenceTreeDialog(model, true);
            dialog.openDialog(PreferenceMenuPiece.this.controller.findRootWindow(), true);
        }
    };

    protected PreferenceMenuPiece() {
        this(null);
    }

    public PreferenceMenuPiece(DockController controller) {
        this.text = new MenuPieceText("PreferenceMenuPiece.text", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                PreferenceMenuPiece.this.action.putValue("Name", newValue);
            }
        };
        this.add(new JMenuItem(this.action));
        this.setController(controller);
    }

    protected PreferenceTreeModel createModel() {
        if (this.controller == null) {
            return new PreferenceTreeModel(this.controller);
        }
        return new DockingFramesPreference(this.controller);
    }

    public PreferenceTreeModel getModel() {
        if (this.model == null) {
            this.model = this.createModel();
        }
        return this.model;
    }

    @Override
    public void bind() {
        super.bind();
        this.text.setController(this.controller);
    }

    @Override
    public void unbind() {
        super.unbind();
        this.text.setController(null);
    }

    public void setController(DockController controller) {
        this.controller = controller;
        this.action.setEnabled(controller != null);
        this.model = null;
        if (this.isBound()) {
            this.text.setController(controller);
        }
    }

    public DockController getController() {
        return this.controller;
    }
}

