/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.predefined.CMaximizeAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.mode.AbstractLocationMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.facile.mode.action.MaximizedModeAction;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.util.Path;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class MaximizedMode<M extends MaximizedModeArea>
extends AbstractLocationMode<M> {
    public static final Path IDENTIFIER = new Path("dock.mode.maximized");
    public static final String ICON_IDENTIFIER = "locationmanager.maximize";
    private Map<String, Path> lastMaximizedMode = new HashMap<String, Path>();
    private Map<String, Location> lastMaximizedLocation = new HashMap<String, Location>();
    private Listener listener = new Listener();
    private List<KeyHook> hooks = new LinkedList<KeyHook>();
    private PropertyValue<KeyStroke> keyStrokeMaximizeChange = new PropertyValue<KeyStroke>(CControl.KEY_MAXIMIZE_CHANGE){

        @Override
        protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
        }
    };

    protected MaximizedMode() {
    }

    public MaximizedMode(CControl control) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new CMaximizeAction(control)));
    }

    public MaximizedMode(DockController controller) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new MaximizedModeAction(controller, this)));
    }

    @Override
    public void setManager(LocationModeManager<?> manager) {
        for (KeyHook hook : this.hooks) {
            hook.destroy(false);
        }
        this.hooks.clear();
        LocationModeManager<?> old = this.getManager();
        this.listener.replaceManager(old, manager);
        if (manager == null) {
            this.keyStrokeMaximizeChange.setProperties((DockProperties)null);
        } else {
            this.keyStrokeMaximizeChange.setProperties(manager.getController());
        }
        super.setManager(manager);
    }

    @Override
    public Path getUniqueIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public ExtendedMode getExtendedMode() {
        return ExtendedMode.MAXIMIZED;
    }

    @Override
    public boolean runApply(Dockable dockable, Location history, AffectedSet set) {
        MaximizedModeArea area = this.getMaximizeArea(dockable, history);
        if (area == null) {
            area = (MaximizedModeArea)this.getDefaultArea();
        }
        area.prepareApply(dockable, history, set);
        return this.maximize(area, dockable, history, set);
    }

    @Override
    public Location current(Dockable dockable) {
        MaximizedModeArea area = (MaximizedModeArea)this.get(dockable);
        if (area == null) {
            return null;
        }
        DockableProperty location = area.getLocation(dockable);
        return new Location(this.getUniqueIdentifier(), area.getUniqueId(), location, false);
    }

    @Override
    public boolean isCurrentMode(Dockable dockable) {
        for (MaximizedModeArea area : this) {
            if (!area.isChild(dockable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultMode(Dockable dockable) {
        return false;
    }

    @Override
    public boolean isRepresenting(DockStation station) {
        if (super.isRepresenting(station)) {
            return true;
        }
        Dockable dockable = station.asDockable();
        if (dockable == null) {
            return false;
        }
        for (MaximizedModeArea area : this) {
            if (!area.isChild(dockable)) continue;
            return true;
        }
        return false;
    }

    public LocationMode getUnmaximizedMode(Dockable dockable) {
        while (dockable != null) {
            for (MaximizedModeArea area : this) {
                if (!area.isChild(dockable)) continue;
                return area.getUnmaximizedMode();
            }
            DockStation parent = dockable.getDockParent();
            dockable = parent == null ? null : parent.asDockable();
        }
        return null;
    }

    public void maximize(MaximizedModeArea area, Dockable dockable, AffectedSet set) {
        this.maximize(area, dockable, null, set);
    }

    public boolean maximize(MaximizedModeArea area, Dockable dockable, Location history, AffectedSet set) {
        Dockable maximizing = this.getMaximizingElement(dockable);
        if (maximizing != dockable) {
            this.getManager().store(maximizing);
        }
        if (area == null) {
            area = this.getMaximizeArea(maximizing);
        }
        if (area == null) {
            area = (MaximizedModeArea)this.getDefaultArea();
        }
        String id = this.getManager().getKey(maximizing);
        Mode current = this.getManager().getCurrentMode(maximizing);
        if (id == null && current == null) {
            throw new IllegalStateException("an unidentified dockable without location has been found, all dockables except true root-station must have a location, true root-stations can never be used in this method.");
        }
        if (id == null && current != null) {
            this.lastMaximizedLocation.put(area.getUniqueId(), (Location)current.current(maximizing));
            this.lastMaximizedMode.put(area.getUniqueId(), current.getUniqueIdentifier());
        } else {
            this.getManager().store(dockable);
        }
        List<Dockable> oldMaximized = this.getMaximized(area);
        area.setMaximized(maximizing, true, history, set);
        if (id != null || current != null) {
            block0: for (Dockable newMaximized : area.getMaximized()) {
                if (newMaximized == maximizing || !DockUtilities.isAncestor(newMaximized, maximizing) || oldMaximized.contains(newMaximized)) continue;
                for (Dockable replaced : oldMaximized) {
                    if (!DockUtilities.isAncestor(newMaximized, replaced)) continue;
                    this.storeLastMaximizedLocation(area, replaced);
                    continue block0;
                }
            }
        }
        set.add(maximizing);
        return true;
    }

    private List<Dockable> getMaximized(MaximizedModeArea area) {
        Dockable[] children = area.getMaximized();
        if (children == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(children);
    }

    private void storeLastMaximizedLocation(MaximizedModeArea area, Dockable dockable) {
        Location previousLocation;
        LocationMode previousMode = (LocationMode)this.getManager().getPreviousMode(dockable);
        if (previousMode != null && (previousLocation = (Location)this.getManager().getHistory(dockable, previousMode.getUniqueIdentifier())) != null) {
            this.lastMaximizedLocation.put(area.getUniqueId(), previousLocation);
            this.lastMaximizedMode.put(area.getUniqueId(), previousMode.getUniqueIdentifier());
        }
    }

    public void unmaximize(Dockable dockable, AffectedSet set) {
        Dockable[] maximized;
        final MaximizedModeArea area = this.getMaximizeArea(dockable);
        if (area != null && area.getMaximized() != null && (maximized = area.getMaximized()) != null) {
            for (Dockable check : maximized) {
                if (!DockUtilities.isAncestor(check, dockable)) continue;
                set.add(dockable);
                final Dockable element = dockable = check;
                LocationModeManager<?> manager = this.getManager();
                manager.runTransaction(new AffectingRunnable(){

                    @Override
                    public void run(AffectedSet set) {
                        area.setMaximized(element, false, null, set);
                        String key = area.getUniqueId();
                        boolean done = false;
                        if (MaximizedMode.this.lastMaximizedLocation.get(key) != null) {
                            done = MaximizedMode.this.getManager().apply(element, (Path)MaximizedMode.this.lastMaximizedMode.remove(key), MaximizedMode.this.lastMaximizedLocation.remove(key), set);
                        }
                        if (!done) {
                            MaximizedMode.this.applyOldLocation(element, set);
                        }
                    }
                }, true);
                manager.store(dockable);
                return;
            }
        }
    }

    private void applyOldLocation(Dockable element, AffectedSet set) {
        LocationModeManager<?> manager = this.getManager();
        if (manager.isRegistered(element)) {
            LocationMode mode = (LocationMode)manager.getPreviousMode(element);
            if (mode == null || mode == this) {
                mode = (LocationMode)manager.getMode(NormalMode.IDENTIFIER);
            }
            manager.apply(element, mode.getUniqueIdentifier(), set, true);
        } else if (element.asDockStation() != null) {
            DockStation station = element.asDockStation();
            Dockable[] children = new Dockable[station.getDockableCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = station.getDockable(i);
            }
            for (Dockable child : children) {
                this.applyOldLocation(child, set);
            }
        }
    }

    public MaximizedModeArea getNextMaximizeArea(DockStation station) {
        while (station != null) {
            MaximizedModeArea area = this.getMaximizeArea(station);
            if (area != null) {
                return area;
            }
            Dockable dockable = station.asDockable();
            if (dockable == null) {
                return null;
            }
            station = dockable.getDockParent();
        }
        return null;
    }

    public void unmaximize(DockStation station, AffectedSet affected) {
        Dockable[] dockables;
        MaximizedModeArea area = this.getNextMaximizeArea(station);
        if (area != null && (dockables = area.getMaximized()) != null) {
            for (Dockable dockable : dockables) {
                this.unmaximize(dockable, affected);
            }
        }
    }

    public void unmaximize(MaximizedModeArea area, AffectedSet affected) {
        Dockable[] dockables = area.getMaximized();
        if (dockables != null) {
            for (Dockable dockable : dockables) {
                this.unmaximize(dockable, affected);
            }
        }
    }

    @Override
    public void ensureNotHidden(final Dockable dockable) {
        this.getManager().runTransaction(new AffectingRunnable(){

            @Override
            public void run(AffectedSet set) {
                Dockable mutableDockable = dockable;
                DockStation parent = mutableDockable.getDockParent();
                Dockable element = MaximizedMode.this.getMaximizingElement(mutableDockable);
                while (parent != null) {
                    Dockable[] maximized;
                    MaximizedModeArea area = MaximizedMode.this.getMaximizeArea(parent);
                    if (area != null && (maximized = area.getMaximized()) != null) {
                        for (Dockable check : maximized) {
                            if (maximized == null || check == mutableDockable || check == element) continue;
                            MaximizedMode.this.unmaximize(check, set);
                        }
                    }
                    parent = (mutableDockable = parent.asDockable()) == null ? null : mutableDockable.getDockParent();
                }
            }
        });
    }

    public MaximizedModeArea getMaximizeArea(Dockable dockable, Location history) {
        return this.getMaximizeArea(dockable);
    }

    public MaximizedModeArea getMaximizeArea(Dockable dockable) {
        DockStation parent = dockable.getDockParent();
        while (parent != null) {
            MaximizedModeArea area = this.getMaximizeArea(parent);
            if (area != null) {
                return area;
            }
            dockable = parent.asDockable();
            if (dockable == null) {
                parent = null;
                continue;
            }
            parent = dockable.getDockParent();
        }
        return null;
    }

    public MaximizedModeArea getMaximizeArea(DockStation station) {
        for (MaximizedModeArea area : this) {
            if (!area.isRepresenting(station)) continue;
            return area;
        }
        return null;
    }

    public Dockable getMaximizingElement(Dockable dockable) {
        return this.getManager().getGroupBehavior().getGroupElement(this.getManager(), dockable, this.getExtendedMode());
    }

    public Dockable getMaximizingElement(Dockable old, Dockable dockable) {
        return this.getManager().getGroupBehavior().getReplaceElement(this.getManager(), old, dockable, this.getExtendedMode());
    }

    protected void applyStarting(LocationModeEvent event) {
        Runnable run;
        ArrayList<Runnable> runs = new ArrayList<Runnable>();
        for (MaximizedModeArea area : this) {
            Runnable run2 = area.onApply(event);
            if (run2 == null) continue;
            runs.add(run2);
        }
        Dockable dockable = event.getDockable();
        MaximizedModeArea maxiarea = this.getMaximizeArea(dockable);
        if (maxiarea == null) {
            return;
        }
        Dockable[] maximizedNow = maxiarea.getMaximized();
        if (maximizedNow == null) {
            return;
        }
        Dockable maximized = null;
        for (int i = 0; i < maximizedNow.length; ++i) {
            if (!DockUtilities.isAncestor(maximizedNow[i], dockable)) continue;
            maximized = this.getMaximizingElement(maximizedNow[i], dockable);
            break;
        }
        if ((run = maxiarea.onApply(event, maximized)) != null) {
            runs.add(run);
        }
        if (!runs.isEmpty()) {
            event.setClientObject(this.listener, runs);
        }
    }

    protected void applyDone(LocationModeEvent event) {
        List runs = (List)event.getClientObject(this.listener);
        if (runs != null) {
            for (Runnable run : runs) {
                run.run();
            }
        }
    }

    @Override
    public ModeSettingFactory<Location> getSettingFactory() {
        return MaximizedModeSetting.FACTORY;
    }

    @Override
    public void writeSetting(ModeSetting<Location> setting) {
        if (setting instanceof MaximizedModeSetting) {
            MaximizedModeSetting modeSetting = (MaximizedModeSetting)setting;
            modeSetting.setLastMaximizedLocation(this.lastMaximizedLocation);
            modeSetting.setLastMaximizedMode(this.lastMaximizedMode);
        }
    }

    @Override
    public void readSetting(ModeSetting<Location> setting) {
        if (setting instanceof MaximizedModeSetting) {
            MaximizedModeSetting modeSetting = (MaximizedModeSetting)setting;
            this.lastMaximizedLocation = new HashMap<String, Location>(modeSetting.getLastMaximizedLocation());
            this.lastMaximizedMode = new HashMap<String, Path>(modeSetting.getLastMaximizedMode());
        }
    }

    protected boolean process(Dockable dockable, KeyEvent event) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(event);
        if (stroke.equals(this.keyStrokeMaximizeChange.getValue())) {
            return this.switchMode(dockable);
        }
        return false;
    }

    public boolean switchMode(Dockable dockable) {
        LocationModeManager<?> manager = this.getManager();
        Mode current = manager.getCurrentMode(dockable);
        if (current == this) {
            LocationMode mode = (LocationMode)manager.getPreviousMode(dockable);
            if (mode != null && manager.isModeAvailable(dockable, mode.getExtendedMode())) {
                manager.setMode(dockable, mode.getExtendedMode());
                manager.ensureValidLocation(dockable);
                return true;
            }
        } else if (manager.isModeAvailable(dockable, this.getExtendedMode())) {
            manager.setMode(dockable, this.getExtendedMode());
            manager.ensureValidLocation(dockable);
            return true;
        }
        return false;
    }

    private class Listener
    implements ModeManagerListener<Location, LocationMode>,
    LocationModeListener {
        private Listener() {
        }

        public void replaceManager(LocationModeManager<?> oldManager, LocationModeManager<?> newManager) {
            if (oldManager != null) {
                oldManager.removeModeManagerListener(this);
                for (LocationMode mode : oldManager.modes()) {
                    this.modeRemoved((ModeManager<? extends Location, ? extends LocationMode>)oldManager, mode);
                }
            }
            if (newManager != null) {
                newManager.addModeManagerListener(this);
                for (LocationMode mode : newManager.modes()) {
                    this.modeAdded((ModeManager<? extends Location, ? extends LocationMode>)newManager, mode);
                }
                for (Dockable dockable : newManager.listDockables()) {
                    new KeyHook(dockable);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            new KeyHook(dockable);
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            if (mode != MaximizedMode.this) {
                mode.addLocationModeListener(this);
            }
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable, LocationMode oldMode, LocationMode newMode) {
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            mode.removeLocationModeListener(this);
        }

        @Override
        public void applyDone(LocationModeEvent event) {
            MaximizedMode.this.applyDone(event);
        }

        @Override
        public void applyStarting(LocationModeEvent event) {
            MaximizedMode.this.applyStarting(event);
        }
    }

    private class KeyHook
    extends DockRegisterAdapter
    implements KeyboardListener {
        private Dockable dockable;
        private DockController controller;

        public KeyHook(Dockable dockable) {
            this.dockable = dockable;
            this.controller = MaximizedMode.this.getController();
            this.controller.getKeyboardController().addListener(this);
            this.controller.getRegister().addDockRegisterListener(this);
            MaximizedMode.this.hooks.add(this);
        }

        @Override
        public void dockableUnregistered(DockController controller, Dockable dockable) {
            if (this.dockable == dockable) {
                this.destroy(true);
            }
        }

        public void destroy(boolean complete) {
            this.controller.getKeyboardController().removeListener(this);
            this.controller.getRegister().removeDockRegisterListener(this);
            if (complete) {
                MaximizedMode.this.hooks.remove(this);
            }
        }

        @Override
        public DockElement getTreeLocation() {
            return this.dockable;
        }

        @Override
        public boolean keyPressed(DockElement element, KeyEvent event) {
            return MaximizedMode.this.process(this.dockable, event);
        }

        @Override
        public boolean keyReleased(DockElement element, KeyEvent event) {
            return MaximizedMode.this.process(this.dockable, event);
        }

        @Override
        public boolean keyTyped(DockElement element, KeyEvent event) {
            return MaximizedMode.this.process(this.dockable, event);
        }
    }
}

