/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import java.util.ArrayList;
import java.util.Collection;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class DoAllAcceptanceTest
extends MockObjectTestCase {
    public void testCanSpecifyMultipleStubsForOneInvocation() {
        Mock mockCollector = this.mock(Collector.class);
        Collector collector = (Collector)mockCollector.proxy();
        ArrayList list = new ArrayList();
        mockCollector.expects(this.once()).method("addThingsTo").with(this.same(list)).will(this.doAll(this.addElement("1"), this.addElement("2"), this.addElement("3"), this.addElement("4")));
        collector.addThingsTo(list);
        DoAllAcceptanceTest.assertEquals((String)"list length", (int)4, (int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            DoAllAcceptanceTest.assertEquals((String)("element " + (i + 1)), (Object)Integer.toString(i + 1), list.get(i));
        }
    }

    private Stub addElement(String newElement) {
        return new AddElementStub(newElement);
    }

    public static class AddElementStub
    implements Stub {
        private final String newElement;

        public AddElementStub(String newElement) {
            this.newElement = newElement;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            ((Collection)invocation.parameterValues.get(0)).add(this.newElement);
            return null;
        }

        public StringBuffer describeTo(StringBuffer buffer) {
            throw new UnsupportedOperationException("AddElementStub.describeTo not implemented");
        }
    }

    public static interface Collector {
        public void addThingsTo(Collection var1);
    }
}

