/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.jmock.core.Formatting;
import org.jmock.core.SelfDescribing;

public class Invocation
implements SelfDescribing {
    public final Object invokedObject;
    public final Method invokedMethod;
    public final List parameterValues;
    private static final Map BOX_TYPES = Invocation.makeBoxTypesMap();

    public Invocation(Object invoked, Method method, Object[] parameterValues) {
        this.invokedObject = invoked;
        this.invokedMethod = method;
        this.parameterValues = parameterValues == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(Arrays.asList(parameterValues));
    }

    public String toString() {
        return this.describeTo(new StringBuffer()).toString();
    }

    public boolean equals(Object other) {
        return other instanceof Invocation && this.equals((Invocation)other);
    }

    public boolean equals(Invocation other) {
        return other != null && this.invokedObject == other.invokedObject && this.invokedMethod.equals(other.invokedMethod) && ((Object)this.parameterValues).equals(other.parameterValues);
    }

    public int hashCode() {
        return this.invokedObject.hashCode() ^ this.invokedMethod.hashCode() ^ ((Object)this.parameterValues).hashCode();
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        buffer.append(this.invokedObject.toString()).append(".").append(this.invokedMethod.getName());
        Formatting.join(this.parameterValues, buffer, "(", ")");
        return buffer;
    }

    public void checkReturnTypeCompatibility(Object result) {
        Class<?> returnType = this.invokedMethod.getReturnType();
        if (returnType == Void.TYPE) {
            this.failIfReturnTypeIsNotNull(result);
        } else if (result == null) {
            this.failIfReturnTypeIsPrimitive();
        } else {
            Class<?> valueType = result.getClass();
            if (!this.isCompatible(returnType, valueType)) {
                this.reportTypeError(returnType, valueType);
            }
        }
    }

    private boolean isCompatible(Class returnType, Class valueType) {
        if (returnType.isPrimitive()) {
            return this.isBoxedType(returnType, valueType);
        }
        return returnType.isAssignableFrom(valueType);
    }

    private boolean isBoxedType(Class primitiveType, Class referenceType) {
        return BOX_TYPES.get(primitiveType) == referenceType;
    }

    private void failIfReturnTypeIsNotNull(Object result) {
        Assert.assertNull((String)"tried to return a value from a void method", (Object)result);
    }

    private void failIfReturnTypeIsPrimitive() {
        Class<?> returnType = this.invokedMethod.getReturnType();
        Assert.assertFalse((String)("tried to return null value from method returning " + returnType.getName()), (boolean)returnType.isPrimitive());
    }

    private void reportTypeError(Class returnType, Class valueType) {
        Assert.fail((String)("tried to return an incompatible value: expected a " + returnType.getName() + " but returned a " + valueType.getName()));
    }

    private static Map makeBoxTypesMap() {
        HashMap<Class<Comparable<Boolean>>, Class> map = new HashMap<Class<Comparable<Boolean>>, Class>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        return map;
    }
}

