/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.j2d.J2DEffectHelper;
import com.sun.scenario.effect.impl.j2d.J2DImage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class J2DRenderer
extends Renderer {
    private static final Set<String> intrinsicPeerNames = new HashSet<String>(5);
    private static final boolean isJava6OrAbove;

    private EffectPeer createIntrinsicPeer(FilterContext filterContext, String string) {
        EffectPeer effectPeer;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.scenario.effect.impl.j2d.J2D" + string + "Peer");
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(new Object[]{filterContext, this, string});
        }
        catch (Exception exception) {
            return null;
        }
        return effectPeer;
    }

    protected abstract EffectPeer createPlatformPeer(FilterContext var1, String var2, int var3);

    protected EffectPeer createPeer(FilterContext filterContext, String string, int n) {
        if (intrinsicPeerNames.contains(string)) {
            return this.createIntrinsicPeer(filterContext, string);
        }
        return this.createPlatformPeer(filterContext, string, n);
    }

    public void clearImage(Filterable filterable) {
        Image image = (Image)filterable.getData();
        if (!isJava6OrAbove && image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            Arrays.fill(nArray, 0);
        } else {
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
            graphics2D.dispose();
        }
    }

    public ImageData createImageData(FilterContext filterContext, Filterable filterable) {
        int n;
        if (!(filterable instanceof J2DImage)) {
            throw new IllegalArgumentException("Identity source must be J2DImage");
        }
        int n2 = filterable.getPhysicalWidth();
        Filterable filterable2 = this.createCompatibleImage(n2, n = filterable.getPhysicalHeight());
        if (filterable2 == null) {
            return null;
        }
        Graphics2D graphics2D = (Graphics2D)((Image)filterable2.getData()).getGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)filterable.getData(), 0, 0, null);
        graphics2D.dispose();
        return new ImageData(filterContext, filterable2, new Rectangle(n2, n));
    }

    public ImageData transform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        Filterable filterable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (filterable != null) {
            Image image = (Image)filterable.getData();
            Image image2 = (Image)imageData.getImage().getData();
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.translate(-rectangle2.x, -rectangle2.y);
            J2DEffectHelper.transformGraphics2D(graphics2D, baseTransform);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image2, rectangle.x, rectangle.y, null);
            graphics2D.dispose();
        }
        imageData.unref();
        return new ImageData(filterContext, filterable, rectangle2);
    }

    static {
        intrinsicPeerNames.add("Crop");
        intrinsicPeerNames.add("Flood");
        intrinsicPeerNames.add("InvertMask");
        intrinsicPeerNames.add("Merge");
        intrinsicPeerNames.add("Reflection");
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("java.awt.LinearGradientPaint", true, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
        isJava6OrAbove = clazz != null;
    }
}

