/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.j2d.J2DHeapImage;
import com.sun.scenario.effect.impl.j2d.J2DRenderer;
import com.sun.scenario.effect.impl.sw.RendererDelegate;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;

public class J2DSWRenderer
extends J2DRenderer {
    private static WeakReference<J2DSWRenderer> jswInstanceRef;
    private static WeakReference<J2DSWRenderer> sseInstanceRef;
    private final RendererDelegate delegate;

    private J2DSWRenderer(RendererDelegate rendererDelegate) {
        this.delegate = rendererDelegate;
    }

    public static synchronized J2DSWRenderer getJSWInstance() {
        J2DSWRenderer j2DSWRenderer = null;
        if (jswInstanceRef == null || (j2DSWRenderer = (J2DSWRenderer)((Object)jswInstanceRef.get())) == null) {
            try {
                Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
                RendererDelegate rendererDelegate = (RendererDelegate)clazz.newInstance();
                j2DSWRenderer = new J2DSWRenderer(rendererDelegate);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return j2DSWRenderer;
    }

    public static synchronized J2DSWRenderer getSSEInstance() {
        J2DSWRenderer j2DSWRenderer = null;
        if (sseInstanceRef == null || (j2DSWRenderer = (J2DSWRenderer)((Object)sseInstanceRef.get())) == null) {
            try {
                Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.sw.sse.SSERendererDelegate");
                RendererDelegate rendererDelegate = (RendererDelegate)clazz.newInstance();
                j2DSWRenderer = new J2DSWRenderer(rendererDelegate);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sseInstanceRef = new WeakReference<J2DSWRenderer>(j2DSWRenderer);
        }
        return j2DSWRenderer;
    }

    public Effect.AccelType getAccelType() {
        return this.delegate.getAccelType();
    }

    protected EffectPeer createPlatformPeer(FilterContext filterContext, String string, int n) {
        EffectPeer effectPeer;
        String string2 = this.delegate.getPlatformPeerName(string, n);
        try {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(new Object[]{filterContext, this, string});
        }
        catch (Exception exception) {
            System.err.println("Error: " + this.getAccelType() + " peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return effectPeer;
    }

    public final J2DHeapImage createCompatibleImage(int n, int n2) {
        return J2DHeapImage.create(n, n2);
    }

    public Renderer.RendererState getRendererState() {
        return Renderer.RendererState.OK;
    }

    protected Renderer getBackupRenderer() {
        return this;
    }

    public boolean isImageDataCompatible(ImageData imageData) {
        Image image = (Image)imageData.getImage().getData();
        return image instanceof BufferedImage && ((BufferedImage)image).getType() == 3;
    }
}

