/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppfila.swing.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import javax.swing.border.Border;

public class TrapezoidBorder
implements Border {
    private final int a;
    private final Color b;
    private final int c;

    public TrapezoidBorder(int topIndent, int thickness, Color color) {
        this.a = topIndent;
        this.c = thickness;
        this.b = color;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.c, this.a + this.c, this.c, this.a + this.c);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.b);
        g2.setStroke(new BasicStroke(this.c));
        int leftX = x + this.a;
        int rightX = x + width - this.a;
        int topY = y;
        int bottomY = y + height - 1;
        Polygon trapezoid = new Polygon();
        trapezoid.addPoint(leftX, topY);
        trapezoid.addPoint(rightX, topY);
        trapezoid.addPoint(x + width - 1, bottomY);
        trapezoid.addPoint(x, bottomY);
        g2.drawPolygon(trapezoid);
        g2.dispose();
    }
}

