/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.Command;
import org.h2.upgrade.v1_1.command.Parser;
import org.h2.upgrade.v1_1.command.Prepared;
import org.h2.upgrade.v1_1.expression.Parameter;
import org.h2.upgrade.v1_1.expression.ParameterInterface;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandContainer
extends Command {
    private Prepared prepared;

    CommandContainer(Parser parser, String string, Prepared prepared) {
        super(parser, string);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ObjectArray<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() throws SQLException {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string = this.prepared.getSQL();
            ObjectArray<Parameter> objectArray = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parseOnly(string);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ObjectArray<Parameter> objectArray2 = this.prepared.getParameters();
            for (int i = 0; i < objectArray2.size(); ++i) {
                Parameter parameter = objectArray.get(i);
                if (!parameter.isValueSet()) continue;
                Value value = parameter.getValue(this.session);
                Parameter parameter2 = objectArray2.get(i);
                parameter2.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
        }
    }

    @Override
    public int update() throws SQLException {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        int n = this.prepared.update();
        this.prepared.trace(this.startTime, n);
        return n;
    }

    @Override
    public ResultInterface query(int n) throws SQLException {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n);
        this.prepared.trace(this.startTime, resultInterface.getRowCount());
        return resultInterface;
    }

    @Override
    public boolean isReadOnly() {
        return this.prepared.isReadOnly();
    }

    @Override
    public ResultInterface queryMeta() throws SQLException {
        return this.prepared.queryMeta();
    }
}

