/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.SchemaCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.schema.Constant;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.value.Value;

public class CreateConstant
extends SchemaCommand {
    private String constantName;
    private Expression expression;
    private boolean ifNotExists;

    public CreateConstant(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.getSchema().findConstant(this.constantName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90114, this.constantName);
        }
        int n = this.getObjectId(false, true);
        Constant constant = new Constant(this.getSchema(), n, this.constantName);
        this.expression = this.expression.optimize(this.session);
        Value value = this.expression.getValue(this.session);
        constant.setValue(value);
        database.addSchemaObject(this.session, constant);
        return 0;
    }

    public void setConstantName(String string) {
        this.constantName = string;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }
}

