/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.SchemaCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.IndexType;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.Table;

public class CreateIndex
extends SchemaCommand {
    private String tableName;
    private String indexName;
    private IndexColumn[] indexColumns;
    private boolean primaryKey;
    private boolean unique;
    private boolean hash;
    private boolean ifNotExists;
    private String comment;

    public CreateIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.indexColumns = indexColumnArray;
    }

    public int update() throws SQLException {
        IndexType indexType;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        boolean bl = database.isPersistent();
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        if (!table.isPersistIndexes()) {
            bl = false;
        }
        int n = this.getObjectId(true, false);
        if (this.indexName == null) {
            this.indexName = this.primaryKey ? table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_AUTO_") : table.getSchema().getUniqueIndexName(this.session, table, "INDEX_");
        }
        if (this.getSchema().findIndex(this.session, this.indexName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(42111, this.indexName);
        }
        if (this.primaryKey) {
            if (table.findPrimaryKey() != null) {
                throw Message.getSQLException(90017);
            }
            indexType = IndexType.createPrimaryKey(bl, this.hash);
        } else {
            indexType = this.unique ? IndexType.createUnique(bl, this.hash) : IndexType.createNonUnique(bl, this.hash);
        }
        IndexColumn.mapColumns(this.indexColumns, table);
        table.addIndex(this.session, this.indexName, n, this.indexColumns, indexType, this.headPos, this.comment);
        return 0;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public void setHash(boolean bl) {
        this.hash = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }
}

