/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.SchemaCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.schema.TriggerObject;
import org.h2.upgrade.v1_1.table.Table;

public class CreateTrigger
extends SchemaCommand {
    private String triggerName;
    private boolean ifNotExists;
    private boolean insteadOf;
    private boolean before;
    private int typeMask;
    private boolean rowBased;
    private int queueSize = 1024;
    private boolean noWait;
    private String tableName;
    private String triggerClassName;
    private boolean force;
    private boolean onRollback;

    public CreateTrigger(Session session, Schema schema) {
        super(session, schema);
    }

    public void setInsteadOf(boolean bl) {
        this.insteadOf = bl;
    }

    public void setBefore(boolean bl) {
        this.before = bl;
    }

    public void setTriggerClassName(String string) {
        this.triggerClassName = string;
    }

    public void setTypeMask(int n) {
        this.typeMask = n;
    }

    public void setRowBased(boolean bl) {
        this.rowBased = bl;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findTrigger(this.triggerName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90041, this.triggerName);
        }
        int n = this.getObjectId(false, true);
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        TriggerObject triggerObject = new TriggerObject(this.getSchema(), n, this.triggerName, table);
        triggerObject.setInsteadOf(this.insteadOf);
        triggerObject.setBefore(this.before);
        triggerObject.setNoWait(this.noWait);
        triggerObject.setQueueSize(this.queueSize);
        triggerObject.setRowBased(this.rowBased);
        triggerObject.setTypeMask(this.typeMask);
        triggerObject.setOnRollback(this.onRollback);
        triggerObject.setTriggerClassName(this.session, this.triggerClassName, this.force);
        database.addSchemaObject(this.session, triggerObject);
        table.addTrigger(triggerObject);
        return 0;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setOnRollback(boolean bl) {
        this.onRollback = bl;
    }
}

