/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.SchemaCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.schema.Sequence;

public class DropSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifExists;

    public DropSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Sequence sequence = this.getSchema().findSequence(this.sequenceName);
        if (sequence == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90036, this.sequenceName);
            }
        } else {
            if (sequence.getBelongsToTable()) {
                throw Message.getSQLException(90082, this.sequenceName);
            }
            database.removeSchemaObject(this.session, sequence);
        }
        return 0;
    }
}

