/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.SchemaCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.schema.TriggerObject;
import org.h2.upgrade.v1_1.table.Table;

public class DropTrigger
extends SchemaCommand {
    private String triggerName;
    private boolean ifExists;

    public DropTrigger(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        TriggerObject triggerObject = this.getSchema().findTrigger(this.triggerName);
        if (triggerObject == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90042, this.triggerName);
            }
        } else {
            Table table = triggerObject.getTable();
            this.session.getUser().checkRight(table, 15);
            database.removeSchemaObject(this.session, triggerObject);
        }
        return 0;
    }
}

