/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.constraint;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.Parser;
import org.h2.upgrade.v1_1.command.Prepared;
import org.h2.upgrade.v1_1.constraint.Constraint;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.Parameter;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.Table;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.util.StringUtils;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueNull;

public class ConstraintReferential
extends Constraint {
    public static final int RESTRICT = 0;
    public static final int CASCADE = 1;
    public static final int SET_DEFAULT = 2;
    public static final int SET_NULL = 3;
    private IndexColumn[] columns;
    private IndexColumn[] refColumns;
    private int deleteAction;
    private int updateAction;
    private Table refTable;
    private Index index;
    private Index refIndex;
    private boolean indexOwner;
    private boolean refIndexOwner;
    private String deleteSQL;
    private String updateSQL;
    private boolean skipOwnTable;

    public ConstraintReferential(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    public String getConstraintType() {
        return "REFERENTIAL";
    }

    private void appendAction(StatementBuilder statementBuilder, int n) {
        switch (n) {
            case 1: {
                statementBuilder.append("CASCADE");
                break;
            }
            case 2: {
                statementBuilder.append("SET DEFAULT");
                break;
            }
            case 3: {
                statementBuilder.append("SET NULL");
                break;
            }
            default: {
                Message.throwInternalError("action=" + n);
            }
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, this.refTable, string, true);
    }

    /*
     * WARNING - void declaration
     */
    public String getCreateSQLForCopy(Table table, Table table2, String string, boolean bl) {
        void var9_12;
        StatementBuilder statementBuilder = new StatementBuilder("ALTER TABLE ");
        String string2 = table.getSQL();
        statementBuilder.append(string2).append(" ADD CONSTRAINT ").append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        IndexColumn[] indexColumnArray = this.columns;
        IndexColumn[] indexColumnArray2 = this.refColumns;
        statementBuilder.append(" FOREIGN KEY(");
        for (IndexColumn indexColumn : indexColumnArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (bl && this.indexOwner && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.index.getSQL());
        }
        statementBuilder.append(" REFERENCES ");
        if (this.table == this.refTable) {
            String string3 = table.getSQL();
        } else {
            String string4 = table2.getSQL();
        }
        statementBuilder.append((String)var9_12).append('(');
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : indexColumnArray2) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (bl && this.refIndexOwner && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.refIndex.getSQL());
        }
        if (this.deleteAction != 0) {
            statementBuilder.append(" ON DELETE ");
            this.appendAction(statementBuilder, this.deleteAction);
        }
        if (this.updateAction != 0) {
            statementBuilder.append(" ON UPDATE ");
            this.appendAction(statementBuilder, this.updateAction);
        }
        return statementBuilder.append(" NOCHECK").toString();
    }

    public String getShortDescription() {
        StatementBuilder statementBuilder = new StatementBuilder(this.getName());
        statementBuilder.append(": ").append(this.table.getSQL()).append(" FOREIGN KEY(");
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(") REFERENCES ").append(this.refTable.getSQL()).append('(');
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.refColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.refTable, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setRefColumns(IndexColumn[] indexColumnArray) {
        this.refColumns = indexColumnArray;
    }

    public IndexColumn[] getRefColumns() {
        return this.refColumns;
    }

    public void setRefTable(Table table) {
        this.refTable = table;
        if (table.isTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    public void setRefIndex(Index index, boolean bl) {
        this.refIndex = index;
        this.refIndexOwner = bl;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        this.refTable.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        if (this.refIndexOwner) {
            this.refTable.removeIndexOrTransferOwnership(session, this.refIndex);
        }
        this.database.removeMeta(session, this.getId());
        this.refTable = null;
        this.index = null;
        this.refIndex = null;
        this.columns = null;
        this.refColumns = null;
        this.deleteSQL = null;
        this.updateSQL = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) throws SQLException {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.refTable.getCheckForeignKeyConstraints()) {
            return;
        }
        if (table == this.table && !this.skipOwnTable) {
            this.checkRowOwnTable(session, row, row2);
        }
        if (table == this.refTable) {
            this.checkRowRefTable(session, row, row2);
        }
    }

    private void checkRowOwnTable(Session session, Row row, Row row2) throws SQLException {
        Object object;
        int n;
        if (row2 == null) {
            return;
        }
        boolean bl = row != null;
        Object object2 = this.columns;
        int n2 = ((IndexColumn[])object2).length;
        for (n = 0; n < n2; ++n) {
            object = object2[n];
            int n3 = ((IndexColumn)object).column.getColumnId();
            Value value = row2.getValue(n3);
            if (value == ValueNull.INSTANCE) {
                return;
            }
            if (!bl || value.compareEqual(row.getValue(n3))) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        if (this.refTable == this.table) {
            boolean bl2 = true;
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                n = this.columns[n2].column.getColumnId();
                object = row2.getValue(n);
                Column column = this.refColumns[n2].column;
                int n4 = column.getColumnId();
                Value value = row2.getValue(n4);
                if (this.database.areEqual(value, (Value)object)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                return;
            }
        }
        object2 = this.refTable.getTemplateRow();
        for (n2 = 0; n2 < this.columns.length; ++n2) {
            n = this.columns[n2].column.getColumnId();
            object = row2.getValue(n);
            Column column = this.refColumns[n2].column;
            int n5 = column.getColumnId();
            ((Row)object2).setValue(n5, column.convert((Value)object));
        }
        if (!this.existsRow(session, this.refIndex, (SearchRow)object2, null)) {
            throw Message.getSQLException(23002, this.getShortDescription());
        }
    }

    private boolean existsRow(Session session, Index index, SearchRow searchRow, Row row) throws SQLException {
        Table table = index.getTable();
        table.lock(session, false, false);
        Cursor cursor = index.find(session, searchRow, searchRow);
        while (cursor.next()) {
            SearchRow searchRow2 = cursor.getSearchRow();
            if (row != null && searchRow2.getKey() == row.getKey()) continue;
            Column[] columnArray = index.getColumns();
            boolean bl = true;
            for (int i = 0; i < this.columns.length && i < columnArray.length; ++i) {
                Value value;
                int n = columnArray[i].getColumnId();
                Value value2 = searchRow.getValue(n);
                if (table.compareTypeSave(value2, value = searchRow2.getValue(n)) == 0) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(Row row, Row row2) throws SQLException {
        return this.refIndex.compareRows(row, row2) == 0;
    }

    private void checkRow(Session session, Row row) throws SQLException {
        Row row2;
        SearchRow searchRow = this.table.getTemplateSimpleRow(false);
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.refColumns[i].column;
            int n = column.getColumnId();
            Column column2 = this.columns[i].column;
            Value value = column2.convert(row.getValue(n));
            searchRow.setValue(column2.getColumnId(), value);
        }
        Row row3 = row2 = this.refTable == this.table ? row : null;
        if (this.existsRow(session, this.index, searchRow, row2)) {
            throw Message.getSQLException(23003, this.getShortDescription());
        }
    }

    private void checkRowRefTable(Session session, Row row, Row row2) throws SQLException {
        if (row == null) {
            return;
        }
        if (row2 != null && this.isEqual(row, row2)) {
            return;
        }
        if (row2 == null) {
            if (this.deleteAction == 0) {
                this.checkRow(session, row);
            } else {
                int n = this.deleteAction == 1 ? 0 : this.columns.length;
                Prepared prepared = this.getDelete(session);
                this.setWhere(prepared, n, row);
                this.updateWithSkipCheck(prepared);
            }
        } else if (this.updateAction == 0) {
            this.checkRow(session, row);
        } else {
            Prepared prepared = this.getUpdate(session);
            if (this.updateAction == 1) {
                ObjectArray<Parameter> objectArray = prepared.getParameters();
                for (int i = 0; i < this.columns.length; ++i) {
                    Parameter parameter = objectArray.get(i);
                    Column column = this.refColumns[i].column;
                    parameter.setValue(row2.getValue(column.getColumnId()));
                }
            }
            this.setWhere(prepared, this.columns.length, row);
            this.updateWithSkipCheck(prepared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithSkipCheck(Prepared prepared) throws SQLException {
        try {
            this.skipOwnTable = true;
            prepared.update();
        }
        finally {
            this.skipOwnTable = false;
        }
    }

    private void setWhere(Prepared prepared, int n, Row row) {
        for (int i = 0; i < this.refColumns.length; ++i) {
            int n2 = this.refColumns[i].column.getColumnId();
            Value value = row.getValue(n2);
            ObjectArray<Parameter> objectArray = prepared.getParameters();
            Parameter parameter = objectArray.get(n + i);
            parameter.setValue(value);
        }
    }

    public int getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(int n) throws SQLException {
        if (n == this.deleteAction && this.deleteSQL == null) {
            return;
        }
        if (this.deleteAction != 0) {
            throw Message.getSQLException(90045, "ON DELETE");
        }
        this.deleteAction = n;
        this.buildDeleteSQL();
    }

    private void buildDeleteSQL() {
        if (this.deleteAction == 0) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        if (this.deleteAction == 1) {
            statementBuilder.append("DELETE FROM ").append(this.table.getSQL());
        } else {
            this.appendUpdate(statementBuilder);
        }
        this.appendWhere(statementBuilder);
        this.deleteSQL = statementBuilder.toString();
    }

    private Prepared getUpdate(Session session) throws SQLException {
        return this.prepare(session, this.updateSQL, this.updateAction);
    }

    private Prepared getDelete(Session session) throws SQLException {
        return this.prepare(session, this.deleteSQL, this.deleteAction);
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(int n) throws SQLException {
        if (n == this.updateAction && this.updateSQL == null) {
            return;
        }
        if (this.updateAction != 0) {
            throw Message.getSQLException(90045, "ON UPDATE");
        }
        this.updateAction = n;
        this.buildUpdateSQL();
    }

    private void buildUpdateSQL() {
        if (this.updateAction == 0) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        this.appendUpdate(statementBuilder);
        this.appendWhere(statementBuilder);
        this.updateSQL = statementBuilder.toString();
    }

    public void rebuild() {
        this.buildUpdateSQL();
        this.buildDeleteSQL();
    }

    private Prepared prepare(Session session, String string, int n) throws SQLException {
        Prepared prepared = session.prepare(string);
        if (n != 1) {
            ObjectArray<Parameter> objectArray = prepared.getParameters();
            for (int i = 0; i < this.columns.length; ++i) {
                Value value;
                Column column = this.columns[i].column;
                Parameter parameter = objectArray.get(i);
                if (n == 3) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expression = column.getDefaultExpression();
                    if (expression == null) {
                        throw Message.getSQLException(90056, column.getName());
                    }
                    value = expression.getValue(session);
                }
                parameter.setValue(value);
            }
        }
        return prepared;
    }

    private void appendUpdate(StatementBuilder statementBuilder) {
        statementBuilder.append("UPDATE ").append(this.table.getSQL()).append(" SET ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" , ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName())).append("=?");
        }
    }

    private void appendWhere(StatementBuilder statementBuilder) {
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName())).append("=?");
        }
    }

    public Table getRefTable() {
        return this.refTable;
    }

    public boolean usesIndex(Index index) {
        return index == this.index || index == this.refIndex;
    }

    public void setIndexOwner(Index index) {
        if (this.index == index) {
            this.indexOwner = true;
        } else if (this.refIndex == index) {
            this.refIndexOwner = true;
        } else {
            Message.throwInternalError();
        }
    }

    public boolean containsColumn(Column column) {
        for (IndexColumn indexColumn : this.columns) {
            if (indexColumn.column != column) continue;
            return true;
        }
        for (IndexColumn indexColumn : this.refColumns) {
            if (indexColumn.column != column) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return false;
    }

    public void checkExistingData(Session session) throws SQLException {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder("SELECT 1 FROM (SELECT ");
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(" FROM ").append(this.table.getSQL()).append(" WHERE ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(indexColumn.getSQL()).append(" IS NOT NULL ");
        }
        statementBuilder.append(" ORDER BY ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(") C WHERE NOT EXISTS(SELECT 1 FROM ").append(this.refTable.getSQL()).append(" P WHERE ");
        statementBuilder.resetCount();
        int n = 0;
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append("C.").append(indexColumn.getSQL()).append('=').append("P.").append(this.refColumns[n++].getSQL());
        }
        statementBuilder.append(')');
        String string = statementBuilder.toString();
        ResultInterface resultInterface = session.prepare(string).query(1);
        if (resultInterface.next()) {
            throw Message.getSQLException(23002, this.getShortDescription());
        }
    }

    public Index getUniqueIndex() {
        return this.refIndex;
    }
}

