/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.constraint;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.Parser;
import org.h2.upgrade.v1_1.constraint.Constraint;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.Table;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.util.StringUtils;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private IndexColumn[] columns;
    private boolean primaryKey;

    public ConstraintUnique(Schema schema, int n, String string, Table table, boolean bl) {
        super(schema, n, string, table);
        this.primaryKey = bl;
    }

    public String getConstraintType() {
        return this.primaryKey ? "PRIMARY KEY" : "UNIQUE";
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, string, true);
    }

    private String getCreateSQLForCopy(Table table, String string, boolean bl) {
        StatementBuilder statementBuilder = new StatementBuilder("ALTER TABLE ");
        statementBuilder.append(table.getSQL()).append(" ADD CONSTRAINT ").append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        statementBuilder.append(' ').append(this.getTypeName()).append('(');
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName()));
        }
        statementBuilder.append(')');
        if (bl && this.indexOwner && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.index.getSQL());
        }
        return statementBuilder.toString();
    }

    private String getTypeName() {
        if (this.primaryKey) {
            return "PRIMARY KEY";
        }
        return "UNIQUE";
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        this.database.removeMeta(session, this.getId());
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) {
    }

    public boolean usesIndex(Index index) {
        return index == this.index;
    }

    public void setIndexOwner(Index index) {
        this.indexOwner = true;
    }

    public boolean containsColumn(Column column) {
        for (IndexColumn indexColumn : this.columns) {
            if (indexColumn.column != column) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) {
    }

    public Index getUniqueIndex() {
        return this.index;
    }

    public void rebuild() {
    }
}

