/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.engine;

import java.util.HashMap;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.DbObjectBase;
import org.h2.upgrade.v1_1.engine.Right;
import org.h2.upgrade.v1_1.engine.Role;
import org.h2.upgrade.v1_1.table.Table;
import org.h2.upgrade.v1_1.util.New;

public abstract class RightOwner
extends DbObjectBase {
    private HashMap<Role, Right> grantedRoles;
    private HashMap<Table, Right> grantedRights;

    protected RightOwner(Database database, int n, String string, String string2) {
        this.initDbObjectBase(database, n, string, string2);
    }

    public boolean isRoleGranted(Role role) {
        if (role == this) {
            return true;
        }
        if (this.grantedRoles != null) {
            for (Role role2 : this.grantedRoles.keySet()) {
                if (role2 == role) {
                    return true;
                }
                if (!role2.isRoleGranted(role)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRightGrantedRecursive(Table table, int n) {
        Right right;
        if (this.grantedRights != null && (right = this.grantedRights.get(table)) != null && (right.getRightMask() & n) == n) {
            return true;
        }
        if (this.grantedRoles != null) {
            for (Role role : this.grantedRoles.keySet()) {
                if (!role.isRightGrantedRecursive(table, n)) continue;
                return true;
            }
        }
        return false;
    }

    public void grantRight(Table table, Right right) {
        if (this.grantedRights == null) {
            this.grantedRights = New.hashMap();
        }
        this.grantedRights.put(table, right);
    }

    public void revokeRight(Table table) {
        if (this.grantedRights == null) {
            return;
        }
        this.grantedRights.remove(table);
        if (this.grantedRights.size() == 0) {
            this.grantedRights = null;
        }
    }

    public void grantRole(Role role, Right right) {
        if (this.grantedRoles == null) {
            this.grantedRoles = New.hashMap();
        }
        this.grantedRoles.put(role, right);
    }

    public void revokeRole(Role role) {
        if (this.grantedRoles == null) {
            return;
        }
        Right right = this.grantedRoles.get(role);
        if (right == null) {
            return;
        }
        this.grantedRoles.remove(role);
        if (this.grantedRoles.size() == 0) {
            this.grantedRoles = null;
        }
    }

    public Right getRightForTable(Table table) {
        if (this.grantedRights == null) {
            return null;
        }
        return this.grantedRights.get(table);
    }

    public Right getRightForRole(Role role) {
        if (this.grantedRoles == null) {
            return null;
        }
        return this.grantedRoles.get(role);
    }
}

