/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.expression;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Comparison;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionVisitor;
import org.h2.upgrade.v1_1.expression.ParameterInterface;
import org.h2.upgrade.v1_1.expression.ValueExpression;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.ColumnResolver;
import org.h2.upgrade.v1_1.table.TableFilter;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueBoolean;
import org.h2.upgrade.v1_1.value.ValueNull;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private Column column;
    private int index;

    public Parameter(int n) {
        this.index = n;
    }

    public String getSQL() {
        return "?" + (this.index + 1);
    }

    public void setValue(Value value, boolean bl) {
        this.value = value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getParamValue() {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    public Value getValue(Session session) {
        return this.getParamValue();
    }

    public int getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.column != null) {
            return this.column.getType();
        }
        return -1;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    public void checkSet() throws SQLException {
        if (this.value == null) {
            throw Message.getSQLException(90012, "#" + (this.index + 1));
        }
    }

    public Expression optimize(Session session) {
        return this;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return this.value != null;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public int getScale() {
        if (this.value != null) {
            return this.value.getScale();
        }
        if (this.column != null) {
            return this.column.getScale();
        }
        return 0;
    }

    public long getPrecision() {
        if (this.value != null) {
            return this.value.getPrecision();
        }
        if (this.column != null) {
            return this.column.getPrecision();
        }
        return 0L;
    }

    public int getDisplaySize() {
        if (this.value != null) {
            return this.value.getDisplaySize();
        }
        if (this.column != null) {
            return this.column.getDisplaySize();
        }
        return 0;
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        throw Message.throwInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        return 0;
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public int getIndex() {
        return this.index;
    }
}

