/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.expression;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionColumn;
import org.h2.upgrade.v1_1.expression.Function;
import org.h2.upgrade.v1_1.expression.FunctionInfo;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.LocalResult;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.tools.SimpleResultSet;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.value.DataType;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueArray;
import org.h2.upgrade.v1_1.value.ValueNull;
import org.h2.upgrade.v1_1.value.ValueResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFunction
extends Function {
    private final boolean distinct;
    private final long rowCount;
    private Column[] columnList;

    TableFunction(Database database, FunctionInfo functionInfo, long l) {
        super(database, functionInfo);
        this.distinct = functionInfo.type == 224;
        this.rowCount = l;
    }

    @Override
    public Value getValue(Session session) throws SQLException {
        return this.getTable(session, this.args, false, this.distinct);
    }

    @Override
    protected void checkParameterCount(int n) throws SQLException {
        if (n < 1) {
            throw Message.getSQLException(7001, this.getName(), ">0");
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.getName());
        statementBuilder.append('(');
        int n = 0;
        for (Expression expression : this.args) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(this.columnList[n++].getCreateSQL()).append('=').append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public String getName() {
        return this.distinct ? "TABLE_DISTINCT" : "TABLE";
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) throws SQLException {
        return this.getTable(session, this.args, true, false);
    }

    public void setColumns(ObjectArray<Column> objectArray) {
        this.columnList = new Column[objectArray.size()];
        objectArray.toArray((Column[])this.columnList);
    }

    private ValueResultSet getTable(Session session, Expression[] expressionArray, boolean bl, boolean bl2) throws SQLException {
        Object object;
        int n = this.columnList.length;
        Expression[] expressionArray2 = new Expression[n];
        Database database = session.getDatabase();
        for (int i = 0; i < n; ++i) {
            object = this.columnList[i];
            ExpressionColumn expressionColumn = new ExpressionColumn(database, (Column)object);
            expressionArray2[i] = expressionColumn;
        }
        LocalResult localResult = new LocalResult(session, expressionArray2, n);
        if (bl2) {
            localResult.setDistinct();
        }
        if (!bl) {
            Value[] valueArray;
            Value[] valueArray2;
            int n2;
            object = new Value[n][];
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                valueArray2 = expressionArray[n2].getValue(session);
                if (valueArray2 == ValueNull.INSTANCE) {
                    object[n2] = new Value[0];
                    continue;
                }
                ValueArray valueArray3 = (ValueArray)valueArray2.convertTo(17);
                valueArray = valueArray3.getList();
                object[n2] = valueArray;
                n3 = Math.max(n3, valueArray.length);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                valueArray2 = new Value[n];
                for (int i = 0; i < n; ++i) {
                    Value value;
                    valueArray = object[i];
                    if (valueArray.length <= n2) {
                        value = ValueNull.INSTANCE;
                    } else {
                        Column column = this.columnList[i];
                        value = valueArray[n2];
                        value = column.convert(value);
                        value = value.convertPrecision(column.getPrecision());
                        value = value.convertScale(true, column.getScale());
                    }
                    valueArray2[i] = value;
                }
                localResult.addRow(valueArray2);
            }
        }
        localResult.done();
        object = ValueResultSet.get(this.getSimpleResultSet(localResult, Integer.MAX_VALUE));
        return object;
    }

    private SimpleResultSet getSimpleResultSet(ResultInterface resultInterface, int n) throws SQLException {
        int n2;
        Object[] objectArray;
        int n3;
        int n4 = resultInterface.getVisibleColumnCount();
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray = resultInterface.getColumnName(n3);
            n2 = DataType.convertTypeToSQLType(resultInterface.getColumnType(n3));
            int n5 = MathUtils.convertLongToInt(resultInterface.getColumnPrecision(n3));
            int n6 = resultInterface.getColumnScale(n3);
            simpleResultSet.addColumn((String)objectArray, n2, n5, n6);
        }
        resultInterface.reset();
        for (n3 = 0; n3 < n && resultInterface.next(); ++n3) {
            objectArray = new Object[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                objectArray[n2] = resultInterface.currentRow()[n2].getObject();
            }
            simpleResultSet.addRow(objectArray);
        }
        return simpleResultSet;
    }

    public long getRowCount() {
        return this.rowCount;
    }
}

