/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.index;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.BaseIndex;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.index.IndexType;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.TableData;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueArray;

public abstract class BaseHashIndex
extends BaseIndex {
    public BaseHashIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
    }

    public void close(Session session) {
    }

    public void remove(Session session) {
    }

    protected Value getKey(SearchRow searchRow) {
        if (this.columns.length == 1) {
            Column column = this.columns[0];
            int n = column.getColumnId();
            Value value = searchRow.getValue(n);
            return value;
        }
        Value[] valueArray = new Value[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            valueArray[i] = searchRow.getValue(n);
        }
        return ValueArray.get(valueArray);
    }

    public double getCost(Session session, int[] nArray) {
        for (Column column : this.columns) {
            int n = column.getColumnId();
            int n2 = nArray[n];
            if ((n2 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    public void checkRename() {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("HASH");
    }
}

