/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.index;

public class IndexType {
    private boolean primaryKey;
    private boolean persistent;
    private boolean unique;
    private boolean hash;
    private boolean scan;
    private boolean belongsToConstraint;

    public static IndexType createPrimaryKey(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.primaryKey = true;
        indexType.persistent = bl;
        indexType.hash = bl2;
        indexType.unique = true;
        return indexType;
    }

    public static IndexType createUnique(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.unique = true;
        indexType.persistent = bl;
        indexType.hash = bl2;
        return indexType;
    }

    public static IndexType createNonUnique(boolean bl) {
        return IndexType.createNonUnique(bl, false);
    }

    public static IndexType createNonUnique(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.persistent = bl;
        indexType.hash = bl2;
        return indexType;
    }

    public static IndexType createScan(boolean bl) {
        IndexType indexType = new IndexType();
        indexType.persistent = bl;
        indexType.scan = true;
        return indexType;
    }

    public void setBelongsToConstraint(boolean bl) {
        this.belongsToConstraint = bl;
    }

    public boolean getBelongsToConstraint() {
        return this.belongsToConstraint;
    }

    public boolean isHash() {
        return this.hash;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.primaryKey) {
            stringBuilder.append("PRIMARY KEY");
            if (this.hash) {
                stringBuilder.append(" HASH");
            }
        } else {
            if (this.unique) {
                stringBuilder.append("UNIQUE ");
            }
            if (this.hash) {
                stringBuilder.append("HASH ");
            }
            stringBuilder.append("INDEX");
        }
        return stringBuilder.toString();
    }

    public boolean isScan() {
        return this.scan;
    }
}

