/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import org.h2.upgrade.v1_1.bnf.Bnf;
import org.h2.upgrade.v1_1.build.BuildBase;
import org.h2.upgrade.v1_1.build.doc.RailroadImages;
import org.h2.upgrade.v1_1.server.web.PageParser;
import org.h2.upgrade.v1_1.tools.Csv;
import org.h2.upgrade.v1_1.util.IOUtils;
import org.h2.upgrade.v1_1.util.StringUtils;

public class Railroads {
    private Bnf bnf;
    private HashMap<String, Object> session = new HashMap();

    public static void main(String ... stringArray) throws Exception {
        new Railroads().process();
    }

    private void process() throws Exception {
        RailroadImages.main((String[])new String[0]);
        this.bnf = Bnf.getInstance(Railroads.getReader());
        ResultSet resultSet = Csv.getInstance().read(Railroads.getReader(), null);
        this.map("grammar", resultSet, true);
        this.processHtml("jcr-sql2.html");
    }

    private void processHtml(String string) throws Exception {
        String string2 = "src/tools/org/h2/upgrade/v1_1/jcr/";
        String string3 = "docs/html/";
        byte[] byArray = BuildBase.readFile((File)new File(string2 + "stylesheet.css"));
        BuildBase.writeFile((File)new File(string3 + "stylesheet.css"), (byte[])byArray);
        String string4 = string2 + string;
        String string5 = string3 + string;
        new File(string5).getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(string5);
        FileInputStream fileInputStream = new FileInputStream(string4);
        byte[] byArray2 = IOUtils.readBytesAndClose(fileInputStream, 0);
        if (string.endsWith(".html")) {
            String string6 = new String(byArray2);
            string6 = PageParser.parse(string6, this.session);
            byArray2 = string6.getBytes();
        }
        fileOutputStream.write(byArray2);
        fileOutputStream.close();
    }

    private static Reader getReader() {
        return new InputStreamReader(Railroads.class.getResourceAsStream("help.csv"));
    }

    private void map(String string, ResultSet resultSet, boolean bl) throws Exception {
        Object object;
        ArrayList arrayList = new ArrayList();
        while (resultSet.next()) {
            String string2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                string2 = StringUtils.toLowerEnglish(resultSetMetaData.getColumnLabel(i + 1));
                object = resultSet.getString(i + 1);
                object = ((String)object).trim();
                hashMap.put(string2, PageParser.escapeHtml((String)object));
            }
            String string3 = resultSet.getString("TOPIC");
            string2 = resultSet.getString("SYNTAX").trim();
            if (bl) {
                object = this.bnf.getRailroadHtml(string2);
                hashMap.put("railroad", object);
            }
            string2 = this.bnf.getSyntaxHtml(string2);
            hashMap.put("syntax", string2);
            object = (String)hashMap.get("text");
            if (object != null) {
                object = StringUtils.replaceAll((String)object, "<br /><br />", "</p><p>");
                object = StringUtils.replaceAll((String)object, "<br />", " ");
                hashMap.put("text", object);
            }
            String string4 = string3.toLowerCase();
            string4 = StringUtils.replaceAll(string4, " ", "_");
            string4 = StringUtils.replaceAll(string4, "@", "_");
            hashMap.put("link", StringUtils.urlEncode(string4));
            arrayList.add(hashMap);
        }
        this.session.put(string, arrayList);
        int n = 3;
        int n2 = (arrayList.size() + n - 1) / n;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            object = arrayList.subList(n4, Math.min(n4 + n2, arrayList.size()));
            this.session.put(string + "-" + n3, object);
            ++n3;
            n4 += n2;
        }
        resultSet.close();
    }
}

